package com.pcauto.lib.duiba.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 兑吧消费响应参数
 *
 * @author sam
 * @since 2019/8/19
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DuibaCreditConsumeResponse {

    /**
     * 扣积分结果状态，回复ok或者fail （不要使用0和1）
     */
    private String status;

    /**
     * 出错原因
     */
    private String errorMessage = "";

    /**
     * 开发者的订单号(唯一且不重复，如果失败情况，该值可以不传)
     */
    private String bizId;

    /**
     * 用户积分余额
     */
    private Long credits;

}
