package com.pcauto.lib.duiba.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 兑换结果通知请求参数
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DuibaCreditNotifyRequest {

    /**
     * 兑换是否成功，状态是true和false
     */
    private boolean success;

    /**
     * 开发者的订单号
     */
    private String bizId = "";

    /**
     * 出错原因(带中文，请用utf-8进行解码)
     */
    private String errorMessage = "";

    /**
     * 兑吧订单号
     * 开发者收到通知后，请以兑吧订单号 orderNum 为准进行处理，不要以开发者订单号bizId进行处理
     */
    private String orderNum = "";

    /**
     * 时间戳
     */
    private Date timestamp;

    /**
     * 接口appKey，应用的唯一标识码
     */
    private String appKey;

    /**
     * 用户唯一标识，唯一且不可变
     */
    private String uid = "";

    /**
     * transfer参数，是免登录接口中的额外参数。该参数在访问积分商城时通过免登录URL传给兑吧，兑吧服务端在与开发者后续的接口交互中会回传该参数。
     */
    private String transfer = "";

}
