package com.pcauto.lib.duiba.config;

import com.pcauto.lib.duiba.service.DuibaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

/**
 * @author sam
 * @since 2019/8/19
 */
@Configuration
@EnableConfigurationProperties(com.pcauto.lib.duiba.config.DuibaProperties.class)
public class DuibaConfig {

    @Autowired
    private DuibaProperties duibaProperties;

    @Autowired
    private DuibaService duibaService;

    @Bean
    DuibaCreditTool duibaCreditTool() {
        if (duibaProperties == null || StringUtils.isEmpty(duibaProperties.getAppKey()) || StringUtils.isEmpty(duibaProperties.getAppSecret())) {
            throw new RuntimeException("===============>>> 大哥,你忘记配兑吧的信息了 <<<===============");
        }
        if (duibaService == null) {
            throw new RuntimeException("===============>>> 大哥,你忘记实现 DuibaService了 <<<===============");
        }
        return new DuibaCreditTool(duibaProperties.getAppKey(), duibaProperties.getAppSecret(), duibaProperties.getRoot());
    }

}