package com.pcauto.lib.duiba.controller;

import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.credits.sdk.CreditConsumeResult;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.duiba.config.DuibaCreditTool;
import com.pcauto.lib.duiba.pojo.DuibaCreditConsumeRequest;
import com.pcauto.lib.duiba.pojo.DuibaCreditConsumeResponse;
import com.pcauto.lib.duiba.pojo.DuibaCreditNotifyRequest;
import com.pcauto.lib.duiba.service.DuibaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 兑吧
 *
 * @author sam
 * @since 2019/8/26
 */
@RestController
@Api(tags = "[公用]兑吧接口")
public class DuibaController {

    @Autowired
    private DuibaService duibaService;

    @Autowired
    private DuibaCreditTool creditTool;

    /**
     * 兑吧商城
     *
     * @return
     */
    @GetMapping("/duiba/mall")
    @ApiOperation(value = "获取积分商城链接", notes = "获取积分商城跳转链接")
    public GenericResponse<String> mall(HttpServletRequest request, @RequestParam(required = false) String redirect) {
        if (duibaService == null) {
            throw new RuntimeException("duibaService must be implements");
        }
        String userId = duibaService.getUserId(request);
        if (StringUtils.isEmpty(userId)) {
            throw new RuntimeException("userId empty");
        }
        Long credits = duibaService.getCredits(userId);
        Integer vip = duibaService.getVip(userId);
        return new GenericResponse(1, "OK", creditTool.getLoginFreeUrl(userId, credits, vip, redirect));
    }

    /**
     * 兑换记录
     *
     * @return
     */
    @GetMapping("/duiba/record")
    @ApiOperation(value = "获取兑换记录链接", notes = "获取兑换记录链接")
    public GenericResponse<String> record(HttpServletRequest request) {
        if (duibaService == null) {
            throw new RuntimeException("duibaService must be implements");
        }
        String userId = duibaService.getUserId(request);
        if (StringUtils.isEmpty(userId)) {
            throw new RuntimeException("userId empty");
        }
        Long credits = duibaService.getCredits(userId);
        Integer vip = duibaService.getVip(userId);
        return new GenericResponse(1, "OK", creditTool.getLoginFreeUrl(userId, credits, vip, creditTool.getRoot() + "/crecord/record"));
    }

    /**
     * 扣积分
     *
     * @param request
     * @return
     */
    @GetMapping("/duiba/consume")
    @ApiOperation(value = "扣积分", notes = "扣积分")
    public CreditConsumeResult consume(HttpServletRequest request) {
        if (duibaService == null) {
            throw new RuntimeException("duibaService must be implements");
        }
        String status;
        String errorMessage = "";
        String bizId = "";
        Long credits = 0L;
        try {
            CreditConsumeParams params = creditTool.parseCreditConsume(request);
            DuibaCreditConsumeRequest consumeRequest = new DuibaCreditConsumeRequest();
            BeanUtils.copyProperties(params, consumeRequest);

            // 发起消费
            DuibaCreditConsumeResponse consumeResponse = duibaService.consume(consumeRequest);

            status = consumeResponse.getStatus();
            errorMessage = consumeResponse.getErrorMessage();
            bizId = consumeResponse.getBizId();
            credits = consumeResponse.getCredits();
        } catch (Exception e) {
            status = "fail";
            errorMessage = e.getMessage();
            e.printStackTrace();
        }
        CreditConsumeResult ccr = new CreditConsumeResult();
        ccr.setStatus(status);
        ccr.setBizId(bizId);
        ccr.setErrorMessage(errorMessage);
        ccr.setCredits(credits.toString());
        return ccr;
    }

    /**
     * 兑换结果通知
     *
     * @param request
     * @return
     */
    @GetMapping("/duiba/notify")
    @ApiOperation(value = "兑换结果通知", notes = "兑换结果通知")
    public void notify(HttpServletRequest request, HttpServletResponse response) {
        if (duibaService == null) {
            throw new RuntimeException("duibaService must be implements");
        }
        try {
            // 利用tool来解析这个请求
            CreditNotifyParams params = creditTool.parseCreditNotify(request);
            DuibaCreditNotifyRequest notifyRequest = new DuibaCreditNotifyRequest();
            BeanUtils.copyProperties(params, notifyRequest);

            boolean result = duibaService.notify(notifyRequest);
            response.getWriter().write(result ? "ok" : "fail");
            return;
//            return result ? "ok" : "fail";
//            String orderNum = params.getOrderNum();
//            if (params.isSuccess()) {
//                //兑换成功
//            } else {
//                //兑换失败，根据orderNum，对用户的金币进行返还，回滚操作
//            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        try {
            response.getWriter().write("fail");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


}
