package com.pcauto.lib.duiba.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 兑吧消费请求参数
 *
 * @author sam
 * @since 2019/8/19
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DuibaCreditConsumeRequest {

    /**
     * 接口appKey，应用的唯一标识
     */
    private String appKey;

    /**
     * 时间戳
     */
    private Date timestamp;

    /**
     * 用户唯一性标识，唯一且不可变
     */
    private String uid = "";

    /**
     * 消耗积分数
     */
    private Long credits;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 本次积分消耗的描述
     */
    private String description;

    /**
     * 商品编码，非必须参数
     */
    private String itemCode = "";

    /**
     * 面值,兑换商品的市场价值，单位:分
     */
    private Integer facePrice;

    /**
     * 此次兑换实际扣除开发者账户费用，单位:分
     */
    private Integer actualPrice;

    /**
     * 是否等待审核， 如果返回true，表示此订单需要审核，审核通过后才会继续下去。 如果返回false表示此订单无须审核，会直接继续兑换流程
     * (如需在自身系统进行审核处理，请记录下此信息)
     */
    private boolean waitAudit;

    /**
     * 用户兑换时使用的ip地址，有可能为空
     */
    private String ip;

    /**
     * 兑换类型：alipay(支付宝), qb(Q币), coupon(优惠券), object(实物), phonebill(话费), phoneflow(流量), virtual(虚拟商品),game(游戏), hdtool(活动抽奖),sign(签到)所有类型不区分大小写
     */
    private String type;

    /**
     * 详情参数，不同的类型，返回不同的内容，中间用英文冒号分隔。(支付宝类型带中文，请用utf-8进行解码)
     * 实物商品：返回收货信息(姓名:手机号:省份:城市:区域:街道:详细地址)、
     * 支付宝：返回账号信息(支付宝账号:实名)、
     * 话费：返回手机号、
     * QB：返回QQ号
     */
    private String params;

    /**
     * transfer参数，是免登录接口中的额外参数。该参数在访问积分商城时通过免登录URL传给兑吧，兑吧服务端在与开发者后续的接口交互中会回传该参数。
     */
    private String transfer = "";


}
