package com.pcauto.lib.duiba.service;

import com.pcauto.lib.duiba.pojo.DuibaCreditConsumeRequest;
import com.pcauto.lib.duiba.pojo.DuibaCreditConsumeResponse;
import com.pcauto.lib.duiba.pojo.DuibaCreditNotifyRequest;

import javax.servlet.http.HttpServletRequest;

/**
 * 兑吧service
 *
 * @author sam
 * @since 2019/8/19
 */
public interface DuibaService {

    /**
     * 获取用户id
     *
     * @param request 请求
     * @return
     */
    String getUserId(HttpServletRequest request);

    /**
     * 根据用户id,获取积分余额
     *
     * @param userId
     * @return
     */
    Long getCredits(String userId);

    /**
     * 获取用户 VIP等级
     * @param userId
     * @return
     */
    Integer getVip(String userId);

    /**
     * 兑吧消费通知
     *
     * @param consumeRequest
     * @return
     */
    DuibaCreditConsumeResponse consume(DuibaCreditConsumeRequest consumeRequest);

    /**
     * 兑换结果通知
     *
     * @param notifyRequest
     * @return
     */
    boolean notify(DuibaCreditNotifyRequest notifyRequest);

}
