/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.pocket.repository;

import com.pcauto.pocket.domain.Dealer;
import com.pcauto.pocket.domain.DealerSpecMch_;
import com.pcauto.pocket.domain.Dealer_;
import com.pcauto.pocket.domain.PublicWechat_;
import com.pcauto.pocket.dto.DealerSpecMchDto;
import com.pcauto.pocket.repository.DealerRepositoryCustom;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.SetJoin;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public interface DealerRepository
extends JpaRepository<Dealer, Integer>,
JpaSpecificationExecutor<Dealer>,
DealerRepositoryCustom {
    @Query(value="select d from Dealer d left join d.specMch dmch join d.publicWechats pw where pw.status=1")
    public Page<Dealer> searchJPQL(DealerSpecMchDto.SearchCriteria var1, Pageable var2);

    default public Page<Dealer> search(DealerSpecMchDto.SearchCriteria searchCriteria, Pageable pageable) {
        return this.findAll(DealerRepository.searchBySpecification(searchCriteria), pageable);
    }

    public static Specification<Dealer> searchBySpecification(DealerSpecMchDto.SearchCriteria criteria) {
        return (Specification & Serializable)(root, query, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (criteria.getDealerId() != null) {
                predicates.add(builder.equal((Expression)root.get(Dealer_.id), (Object)criteria.getDealerId()));
            }
            if (!StringUtils.isEmpty((Object)criteria.getDealerName())) {
                predicates.add(builder.like((Expression)root.get(Dealer_.name), "%" + criteria.getDealerName() + "%"));
            }
            SetJoin pwJoin = root.join(Dealer_.publicWechats);
            predicates.add(builder.equal((Expression)pwJoin.get(PublicWechat_.status), (Object)1));
            Join mchJoin = root.join(Dealer_.specMch, JoinType.LEFT);
            if (criteria.getStatus() != null) {
                predicates.add(builder.equal((Expression)mchJoin.get(DealerSpecMch_.status), (Object)criteria.getStatus()));
            }
            return builder.and((Predicate[])predicates.stream().toArray(Predicate[]::new));
        };
    }
}

