/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.pocket.repository;

import com.pcauto.pocket.dto.DealerSpecMchDto;
import com.pcauto.pocket.repository.DealerRepositoryCustom;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DealerRepositoryCustomImpl
implements DealerRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<DealerSpecMchDto.VoX> searchByNativeSQL(DealerSpecMchDto.SearchCriteria criteria, Pageable pageable) {
        StringBuilder dataSql = new StringBuilder("select dmch.id, d.id as dealerId, d.shortName,dmch.mchName,dmch.mchId,dmch.status,dmch.updateTime,dmch.updater from apk_dealer d inner join apk_public_wechat pw on d.id = pw.dealerId and pw.status = 1 left join apk_dealer_specmch dmch on d.id = dmch.dealerId");
        StringBuilder countSql = new StringBuilder("select count(1) from apk_dealer d inner join apk_public_wechat pw on d.id=pw.dealerId and pw.status=1 left join apk_dealer_specmch dmch on d.id = dmch.dealerId");
        StringBuilder whereSql = new StringBuilder(" where 1=1");
        if (criteria.getDealerId() != null) {
            whereSql.append(" and d.id = :dealerId");
        }
        if (!StringUtils.isEmpty((Object)criteria.getDealerName())) {
            whereSql.append(" and d.shortName like :dealerName");
        }
        if (criteria.getStatus() != null) {
            whereSql.append(" and dmch.status = :status");
        }
        if (!StringUtils.isEmpty((Object)criteria.getMchId())) {
            whereSql.append(" and dmch.mchId = :mchId");
        }
        dataSql.append((CharSequence)whereSql);
        countSql.append((CharSequence)whereSql);
        Query query = this.entityManager.createNativeQuery(dataSql.toString());
        ((NativeQuery)query.unwrap(NativeQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        Query countQuery = this.entityManager.createNativeQuery(countSql.toString());
        if (criteria.getDealerId() != null) {
            query.setParameter("dealerId", (Object)criteria.getDealerId());
            countQuery.setParameter("dealerId", (Object)criteria.getDealerId());
        }
        if (!StringUtils.isEmpty((Object)criteria.getDealerName())) {
            query.setParameter("dealerName", (Object)("%" + criteria.getDealerName() + "%"));
            countQuery.setParameter("dealerName", (Object)("%" + criteria.getDealerName() + "%"));
        }
        if (criteria.getStatus() != null) {
            query.setParameter("status", (Object)criteria.getStatus());
            countQuery.setParameter("status", (Object)criteria.getStatus());
        }
        if (!StringUtils.isEmpty((Object)criteria.getMchId())) {
            query.setParameter("mchId", (Object)criteria.getMchId());
            countQuery.setParameter("mchId", (Object)criteria.getMchId());
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resultList = query.getResultList();
        BigInteger count = (BigInteger)countQuery.getSingleResult();
        ArrayList<DealerSpecMchDto.VoX> result = new ArrayList<DealerSpecMchDto.VoX>();
        for (Map entity : resultList) {
            DealerSpecMchDto.VoX vox = new DealerSpecMchDto.VoX();
            vox.setDealerShortName((String)entity.get("shortName"));
            vox.setDealerId((Integer)entity.get("dealerId"));
            vox.setId((Integer)entity.get("id"));
            vox.setMchId((String)entity.get("mchId"));
            vox.setMchName((String)entity.get("mchName"));
            vox.setStatus((Integer)entity.get("status"));
            vox.setUpdater((String)entity.get("updater"));
            vox.setUpdateTime((Date)entity.get("updateTime"));
            result.add(vox);
        }
        PageImpl voPage = new PageImpl(result, pageable, count.longValue());
        return voPage;
    }
}

