/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.pocket.service;

import com.pcauto.lib.core.mvc.pager.PageDto;
import com.pcauto.lib.core.mvc.pager.PageVo;
import com.pcauto.lib.discuss.PageUtil;
import com.pcauto.pocket.domain.Dealer;
import com.pcauto.pocket.dto.DealerDto;
import com.pcauto.pocket.mapper.DealerMapper;
import com.pcauto.pocket.repository.DealerRepository;
import javax.transaction.Transactional;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class DealerService {
    DealerRepository dealerRepository;

    public PageVo<DealerDto.Vo> searchPage(PageDto pageDto, DealerDto.SearchCriteria criteria) {
        Example example = Example.of((Object)DealerMapper.INSTANCE.criteriaToExample(criteria));
        example.getMatcher().withIgnoreNullValues();
        Page voPage = this.dealerRepository.findAll(PageUtil.toPageable(pageDto)).map(entity -> DealerMapper.INSTANCE.entityToVo((Dealer)entity));
        return PageUtil.toPageVo(voPage);
    }

    public void save(DealerDto.CreateDto dealer) {
        Dealer e = DealerMapper.INSTANCE.createDtoToEntity(dealer);
        this.dealerRepository.save(e);
    }

    public DealerDto.VoX findById(Integer id) {
        Dealer e = (Dealer)this.dealerRepository.findById(id).get();
        return DealerMapper.INSTANCE.entityToVoX(e);
    }

    public void update(Integer id, DealerDto.UpdateDto dealer) {
        dealer.setId(id);
        Dealer e = DealerMapper.INSTANCE.updateDtoToEntity(dealer);
        this.dealerRepository.save(e);
    }

    public void delete(Integer id) {
        this.dealerRepository.deleteById(id);
    }

    public DealerService(DealerRepository dealerRepository) {
        this.dealerRepository = dealerRepository;
    }
}

