/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.pocket.service;

import com.pcauto.lib.core.mvc.error.CustomParameterizedException;
import com.pcauto.lib.core.mvc.pager.PageDto;
import com.pcauto.lib.core.mvc.pager.PageVo;
import com.pcauto.lib.discuss.PageUtil;
import com.pcauto.pocket.domain.Dealer;
import com.pcauto.pocket.domain.DealerSpecMch;
import com.pcauto.pocket.dto.DealerSpecMchDto;
import com.pcauto.pocket.mapper.DealerSpecMchMapper;
import com.pcauto.pocket.repository.DealerRepository;
import com.pcauto.pocket.repository.DealerSpecMchRepository;
import java.util.Date;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class DealerSpecMchService {
    DealerSpecMchRepository dealerSpecMchRepository;
    DealerRepository dealerRepository;

    public PageVo<DealerSpecMchDto.VoX> searchPage(PageDto pageDto, DealerSpecMchDto.SearchCriteria criteria) {
        Page voPage = this.dealerRepository.searchByNativeSQL(criteria, PageUtil.toPageable(pageDto));
        return PageUtil.toPageVo(voPage);
    }

    public DealerSpecMchDto.VoX findById(Integer id) {
        DealerSpecMch e = (DealerSpecMch)this.dealerSpecMchRepository.findById(id).get();
        return DealerSpecMchMapper.INSTANCE.entityToVoX(e);
    }

    public void update(Integer id, DealerSpecMchDto.UpdateDto dealerSpecMch) {
        Optional spe = this.dealerSpecMchRepository.findById(id);
        DealerSpecMch fromDb = null;
        if (!spe.isPresent()) {
            Dealer d = new Dealer();
            d.setId(dealerSpecMch.getId());
            if (this.dealerSpecMchRepository.existsByDealer(d)) {
                throw new CustomParameterizedException("\u8be5\u7ecf\u9500\u5546\u7684\u7279\u7ea6\u5546\u6237\u53f7\u5df2\u5b58\u5728", new String[0]);
            }
            if (this.dealerSpecMchRepository.existsByMchIdEquals(dealerSpecMch.getMchId())) {
                throw new CustomParameterizedException("\u8be5\u7279\u7ea6\u5546\u6237\u53f7\u5df2\u88ab\u5176\u4ed6\u7ecf\u9500\u5546\u4f7f\u7528", new String[0]);
            }
            fromDb = new DealerSpecMch();
            fromDb.setStatus(0);
            fromDb.setUpdateTime(new Date());
        } else {
            fromDb = (DealerSpecMch)spe.get();
        }
        fromDb.setUpdateTime(new Date());
        fromDb.setUpdater("admin");
        fromDb.setStatus(dealerSpecMch.getStatus());
        fromDb.setMchId(dealerSpecMch.getMchId());
        fromDb.setMchName(dealerSpecMch.getMchName());
        this.dealerSpecMchRepository.save(fromDb);
    }

    public void delete(Integer id) {
        this.dealerSpecMchRepository.deleteById(id);
    }

    public DealerSpecMchService(DealerSpecMchRepository dealerSpecMchRepository, DealerRepository dealerRepository) {
        this.dealerSpecMchRepository = dealerSpecMchRepository;
        this.dealerRepository = dealerRepository;
    }
}

