package com.pcauto.lib.mcached;

import com.google.code.ssm.Cache;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeoutException;

/**
 * 看到autopocket使用了mc实现，大量的并发控制功能
 * 为保留习惯，此类实现同样的功能
 * 如果后面切换其他锁，再提取接口到独立模块
 *
 * <p>
 * TODO 添加锁版本 原因:线程A取得锁但任务较久还没释放锁就锁过期了,此时B线程取得了锁,然而线程A任务完成后去释放锁(此时释放的是B线程的锁),就有问题
 * <p>
 * TODO 需要完善锁续期功能
 *
 * @author henry
 */
@Component
public class McLock {

    @Autowired
    Cache cache;

    public boolean tryLock(String key, Object value, int seconds) {
        boolean required = false;
        try {
            required = cache.add(key, seconds, value, SerializationType.PROVIDER);
        } catch (TimeoutException | CacheException e) {
            e.printStackTrace();
        }
        return required;
    }

    public boolean freeLock(String key) {
        boolean result = false;
        try {
            result = cache.delete(key);
        } catch (TimeoutException | CacheException e) {
            e.printStackTrace();
        }
        return result;
    }
}
