package com.pcauto.lib.mcached.config;

import com.google.code.ssm.CacheFactory;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.config.AbstractSSMConfiguration;
import com.google.code.ssm.config.DefaultAddressProvider;
import com.google.code.ssm.mapper.JsonObjectMapper;
import com.google.code.ssm.providers.CacheClientFactory;
import com.google.code.ssm.providers.CacheConfiguration;
import com.google.code.ssm.providers.xmemcached.MemcacheClientFactoryImpl;
import com.google.code.ssm.spring.SSMCache;
import com.google.code.ssm.spring.SSMCacheManager;
import com.google.code.ssm.transcoders.JsonTranscoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.Collection;

/**
 * @author henry
 * 仿照 memcached-context.xml写的JavaConfig
 */
//@ImportResource(locations = {"classpath:simplesm-context.xml"})
//@ImportResource(locations = {"classpath:memcached-context.xml"})
@ConditionalOnProperty(prefix = "memcache", value = "servers")
@Configuration
@EnableConfigurationProperties(MemcacheProperties.class)
public class SSMConfig extends AbstractSSMConfiguration {
    @Autowired
    MemcacheProperties prop;

    @Override
    @Bean
    public CacheFactory defaultMemcachedClient() {
        final CacheConfiguration conf = new CacheConfiguration();
        conf.setConsistentHashing(true);
        final CacheFactory cf = new CacheFactory();

        CacheClientFactory clientFactory = new MemcacheClientFactoryImpl();
        cf.setCacheName("autopocket");
        cf.setCacheClientFactory(clientFactory);
        cf.setJsonTranscoder(new JsonTranscoder(new JsonObjectMapper()));
        cf.setDefaultSerializationType(SerializationType.JSON);
        cf.setAddressProvider(new DefaultAddressProvider(prop.getServers()));
        cf.setConfiguration(conf);
        cf.getCache();
        return cf;
    }


    /**
     * @CacheEvict(..., "allEntries" = true) won't work because allowClear is false,
     * so we won't flush accidentally all entries from memcached instance
     * @return
     */
    @Bean
    public CacheManager cacheManager() {
        SSMCacheManager cacheManager = new SSMCacheManager();
        Collection<SSMCache> caches=new ArrayList<>();
        caches.add(new SSMCache(defaultMemcachedClient().getCache(), 300, false));
        cacheManager.setCaches(caches);
        return cacheManager;
    }

} 