/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pcauto.probe.core.config;

import cn.com.pcauto.probe.core.config.ElasticProperties;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ComponentScan(basePackages={"cn.com.pcauto.probe.core"})
@EnableElasticsearchRepositories(basePackages={"cn.com.pcauto.probe.core.repository"})
@EnableConfigurationProperties(value={ElasticProperties.class})
public class BasePackagesConfiguration {
    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.setMaxAge(Long.valueOf(18000L));
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    public ServletRegistrationBean<HttpServlet> monitorRegistrationBean() {
        ServletRegistrationBean registrationBean = new ServletRegistrationBean();
        registrationBean.setServlet((Servlet)new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                this.doPost(req, resp);
            }

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.getWriter().print("true");
                resp.setStatus(200);
            }
        });
        registrationBean.addUrlMappings(new String[]{"/_probe/readiness.probe"});
        return registrationBean;
    }
}

