/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pcauto.probe.core.config;

import cn.com.pcauto.probe.core.config.ElasticProperties;
import java.io.IOException;
import java.time.Duration;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.elasticsearch.rest.RestClientProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import sun.java2d.DisposerRecord;

@Component
public class ElasticsearchClient
implements DisposerRecord {
    @Autowired
    private RestClientProperties restClientProperties;
    @Autowired
    private ElasticProperties elasticProperties;
    private RestHighLevelClient client;

    @Bean
    public RestHighLevelClient getRestHighLevelClient() {
        HttpHost[] hosts = (HttpHost[])this.restClientProperties.getUris().stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        PropertyMapper map = PropertyMapper.get();
        if (this.restClientProperties.getUsername() != null) {
            builder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
                httpAsyncClientBuilder.disableAuthCaching();
                return httpAsyncClientBuilder.setProxy(this.proxy());
            });
        }
        map.from(() -> ((RestClientProperties)this.restClientProperties).getUsername()).whenHasText().to(username -> {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.restClientProperties.getUsername(), this.restClientProperties.getPassword());
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            builder.setHttpClientConfigCallback(arg_0 -> this.lambda$null$2((CredentialsProvider)credentialsProvider, arg_0));
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            map.from(() -> ((RestClientProperties)this.restClientProperties).getConnectionTimeout()).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectTimeout(arg_0));
            map.from(() -> ((RestClientProperties)this.restClientProperties).getReadTimeout()).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setSocketTimeout(arg_0));
            return requestConfigBuilder;
        });
        this.client = new RestHighLevelClient(builder);
        return this.client;
    }

    protected HttpHost proxy() {
        HttpHost proxy = null;
        ElasticProperties.Proxy proxyProperty = this.elasticProperties.getProxy();
        if (proxyProperty.isEnable()) {
            proxy = new HttpHost(proxyProperty.getHost(), proxyProperty.getPort());
        }
        return proxy;
    }

    @Override
    public void dispose() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$null$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.disableAuthCaching();
        return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setProxy(this.proxy());
    }
}

