/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pcauto.probe.core.web;

import cn.com.pcauto.probe.core.web.UndertowGracefulShutdownWrapper;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HandlerWrapper;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;

@Component
public class UndertowCustomizationBean
implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
    private static final Logger log = LoggerFactory.getLogger(UndertowCustomizationBean.class);
    private final UndertowGracefulShutdownWrapper wrapper;

    public UndertowCustomizationBean(UndertowGracefulShutdownWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void customize(UndertowServletWebServerFactory factory) {
        log.debug(">>> Override default UndertowServletWebServerFactory <<<");
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> {
            WebSocketDeploymentInfo webSocketDeploymentInfo = new WebSocketDeploymentInfo();
            webSocketDeploymentInfo.setBuffers((ByteBufferPool)new DefaultByteBufferPool(false, 1024));
            deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)webSocketDeploymentInfo);
            deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)this.wrapper);
        }});
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> builder.setServerOption(UndertowOptions.ENABLE_STATISTICS, (Object)true)});
    }
}

