/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pcauto.probe.core.web;

import cn.com.pcauto.probe.core.web.UndertowGracefulShutdownWrapper;
import io.undertow.Undertow;
import io.undertow.server.ConnectorStatistics;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

@Component
public class UndertowGracefulShutdownListener
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(UndertowGracefulShutdownListener.class);
    private final UndertowGracefulShutdownWrapper undertowGracefulShutdownWrapper;
    private final ServletWebServerApplicationContext context;

    public UndertowGracefulShutdownListener(UndertowGracefulShutdownWrapper undertowGracefulShutdownWrapper, ServletWebServerApplicationContext context) {
        this.undertowGracefulShutdownWrapper = undertowGracefulShutdownWrapper;
        this.context = context;
        log.debug("GracefulShutdownUndertow created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextClosedEvent event) {
        log.debug("Start to shutdown gracefully {}", (Object)event.getTimestamp());
        this.undertowGracefulShutdownWrapper.getGracefulShutdownHandler().shutdown();
        try {
            UndertowServletWebServer webServer = (UndertowServletWebServer)this.context.getWebServer();
            Field field = webServer.getClass().getDeclaredField("undertow");
            field.setAccessible(true);
            Undertow undertow = (Undertow)field.get(webServer);
            List listenerInfo = undertow.getListenerInfo();
            listenerInfo.forEach(listener -> {
                listener.getAddress();
                ConnectorStatistics connectorStatistics = listener.getConnectorStatistics();
                log.info("Listen to the current connector statistics {} for the Undertow {}", (Object)connectorStatistics.getActiveConnections(), (Object)listener.getAddress());
                if (connectorStatistics.getActiveConnections() > 0L) {
                    log.info("Stopping connector statistics:{}", (Object)connectorStatistics.getActiveConnections());
                }
            });
        }
        catch (Exception e) {
            log.warn("Undertow did not shutdown gracefully normally since the exception " + e.toString());
        }
        finally {
            log.info("Finish shutdown gracefully {}", (Object)event.getTimestamp());
        }
    }
}

