/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pcauto.probe.core.constant;

import cn.com.pcauto.probe.core.constant.EventGroupEnum;
import java.util.Arrays;
import java.util.Map;

public enum EventEnum {
    LOGIN("login", "\u767b\u5f55", "", null),
    VIEW_CARD("view_card", "\u6d4f\u89c8\u540d\u7247", "\u67e5\u770b\u4e86\u6211\u7684\u540d\u7247", EventGroupEnum.CARD),
    CONSULT("consult", "\u54a8\u8be2", "\u54a8\u8be2\u4e86\u6211", EventGroupEnum.CONSULT),
    VIEW_CAR_SHOW("view_car_show", "\u8bbf\u95ee\u4e86\u8f66\u578b\u5c55\u5385", "\u8bbf\u95ee\u4e86\u8f66\u578b\u5c55\u5385", EventGroupEnum.CAR_SHOW),
    VIEW_CAR_SERIES("view_car_series", "\u67e5\u770b\u8f66\u7cfb", "%s", EventGroupEnum.CAR_SHOW),
    VIEW_CAR_MODEL("view_car_model", "\u67e5\u770b\u8f66\u578b", "%s", EventGroupEnum.CAR_SHOW),
    VIEW_CAR_INFO("view_car_info", "\u8bbf\u95ee\u4e86\u8d44\u8baf\u5217\u8868", "\u8bbf\u95ee\u4e86\u8d44\u8baf\u5217\u8868", EventGroupEnum.CAR_INFO),
    READ_MORNING_PAPER("read_morning_paper", "\u9605\u8bfb\u65e9\u62a5", "\u9605\u8bfb\u4e86\u6211\u7684\u65e9\u62a5", EventGroupEnum.CAR_INFO),
    READ_ARTICLE("read_article", "\u9605\u8bfb\u6587\u7ae0", "%s", EventGroupEnum.CAR_INFO),
    VIEW_STORE("view_store", "\u6d4f\u89c8\u95e8\u5e97", "\u6d4f\u89c8\u4e86\u6211\u7684\u95e8\u5e97", EventGroupEnum.STORE),
    XCX_WATCH_LIVE("xcx_watch_live", "\u6d4f\u89c8\u76f4\u64ad\u95f4", "\u67e5\u770b\u4e86\u76f4\u64ad\u3010%s\u3011", EventGroupEnum.LIVE),
    XCX_LIKE_LIVE("xcx_like_live", "\u76f4\u64ad\u95f4\u70b9\u8d5e", "\u70b9\u8d5e\u4e86\u76f4\u64ad\u3010%s\u3011", EventGroupEnum.LIVE),
    XCX_SHARE_LIVE("xcx_share_live", "\u8f6c\u53d1\u76f4\u64ad\u95f4", "\u8f6c\u53d1\u4e86\u76f4\u64ad\u3010%s\u3011", EventGroupEnum.LIVE),
    XCX_WATCH_VIDEO("xcx_watch_video", "\u6d4f\u89c8\u5c0f\u89c6\u9891", "\u67e5\u770b\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    XCX_LIKE_VIDEO("xcx_like_video", "\u5c0f\u89c6\u9891\u70b9\u8d5e", "\u70b9\u8d5e\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    XCX_SHARE_VIDEO("xcx_share_video", "\u8f6c\u53d1\u5c0f\u89c6\u9891", "\u8f6c\u53d1\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    WAP_WATCH_LIVE("wap_watch_live", "\u6d4f\u89c8\u76f4\u64ad\u95f4", "\u67e5\u770b\u4e86\u76f4\u64ad\u3010%s\u3011 ", EventGroupEnum.LIVE),
    WAP_LIKE_LIVE("wap_like_live", "\u76f4\u64ad\u95f4\u70b9\u8d5e", "\u70b9\u8d5e\u4e86\u76f4\u64ad\u3010%s\u3011", EventGroupEnum.LIVE),
    WAP_SHARE_LIVE("wap_share_live", "\u8f6c\u53d1\u76f4\u64ad\u95f4", "\u8f6c\u53d1\u4e86\u76f4\u64ad\u3010%s\u3011", EventGroupEnum.LIVE),
    WAP_WATCH_VIDEO("wap_watch_video", "\u6d4f\u89c8\u5c0f\u89c6\u9891", "\u67e5\u770b\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    WAP_LIKE_VIDEO("wap_like_video", "\u5c0f\u89c6\u9891\u70b9\u8d5e", "\u70b9\u8d5e\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    WAP_SHARE_VIDEO("wap_share_video", "\u8f6c\u53d1\u5c0f\u89c6\u9891", "\u8f6c\u53d1\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    AUTOMAN_XCX_WATCH_VIDEO("automan_xcx_watch_video", "\u6d4f\u89c8\u5c0f\u89c6\u9891", "\u67e5\u770b\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    AUTOMAN_XCX_LIKE_VIDEO("automan_xcx_like_video", "\u5c0f\u89c6\u9891\u70b9\u8d5e", "\u70b9\u8d5e\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO),
    AUTOMAN_XCX_SHARE_VIDEO("automan_xcx_share_video", "\u8f6c\u53d1\u5c0f\u89c6\u9891", "\u8f6c\u53d1\u4e86\u5c0f\u89c6\u9891\u3010%s\u3011", EventGroupEnum.VIDEO);

    private final String name;
    private final String mark;
    private final String msg;
    private final EventGroupEnum eum;

    private EventEnum(String name, String mark, String msg, EventGroupEnum eum) {
        this.name = name;
        this.mark = mark;
        this.msg = msg;
        this.eum = eum;
    }

    public static String getMsgByName(String name, Map<String, Object> params) {
        EventEnum eventEnum = Arrays.stream(EventEnum.values()).filter(e -> e.getName().equals(name)).findFirst().orElse(null);
        if (eventEnum == null) {
            return "";
        }
        switch (eventEnum) {
            case XCX_WATCH_LIVE: 
            case XCX_LIKE_LIVE: 
            case XCX_SHARE_LIVE: 
            case WAP_WATCH_LIVE: 
            case WAP_LIKE_LIVE: 
            case WAP_SHARE_LIVE: 
            case XCX_WATCH_VIDEO: 
            case XCX_LIKE_VIDEO: 
            case XCX_SHARE_VIDEO: 
            case WAP_WATCH_VIDEO: 
            case WAP_LIKE_VIDEO: 
            case WAP_SHARE_VIDEO: 
            case READ_ARTICLE: 
            case AUTOMAN_XCX_LIKE_VIDEO: 
            case AUTOMAN_XCX_SHARE_VIDEO: 
            case AUTOMAN_XCX_WATCH_VIDEO: {
                return EventEnum.formatMsg(eventEnum, params.getOrDefault("title", ""));
            }
            case VIEW_CAR_SERIES: 
            case VIEW_CAR_MODEL: {
                return EventEnum.formatMsg(eventEnum, params.getOrDefault("name", ""));
            }
        }
        return eventEnum.getMsg();
    }

    public static String getMarkByName(String name) {
        EventEnum eventEnum = Arrays.stream(EventEnum.values()).filter(e -> e.getName().equals(name)).findFirst().orElse(null);
        if (eventEnum == null) {
            return "";
        }
        return eventEnum.getMark();
    }

    public static EventEnum getEventByGroup(String group) {
        return Arrays.stream(EventEnum.values()).filter(e -> {
            if (e.getEum() == null) {
                return false;
            }
            return e.getEum().getGroup().equals(group);
        }).findFirst().orElse(VIEW_CARD);
    }

    private static String formatMsg(EventEnum eventEnum, Object ... args) {
        return String.format(eventEnum.getMsg(), args);
    }

    public static Object[] getEventName() {
        return Arrays.stream(EventEnum.values()).filter(e -> e != LOGIN).map(EventEnum::getName).toArray();
    }

    public String getName() {
        return this.name;
    }

    public String getMark() {
        return this.mark;
    }

    public String getMsg() {
        return this.msg;
    }

    public EventGroupEnum getEum() {
        return this.eum;
    }
}

