/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pcauto.probe.core.service.impl;

import cn.com.pcauto.pocket.support.core.utils.ObjectConvert;
import cn.com.pcauto.probe.core.service.ElasticsearchService;
import java.io.IOException;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ElasticsearchServiceImpl
implements ElasticsearchService {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchServiceImpl.class);
    @Autowired
    private RestHighLevelClient highLevelClient;

    @Override
    public String save(String index, Object doc) {
        return this.save(index, null, doc);
    }

    @Override
    public String save(String index, String id, Object doc) {
        if (StringUtils.isEmpty((Object)index)) {
            throw new RuntimeException("index must not be empty");
        }
        if (doc == null) {
            throw new RuntimeException("doc must not be null");
        }
        try {
            String endpoint = "/" + index + "/_doc" + (StringUtils.isEmpty((Object)id) ? "" : "/" + id);
            Request request = new Request("POST", endpoint);
            request.addParameter("pretty", "true");
            request.setEntity((HttpEntity)new NStringEntity(ObjectConvert.toJSONString((Object)doc), ContentType.APPLICATION_JSON));
            Response response = this.highLevelClient.getLowLevelClient().performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("ResponseBody: ", (Object)responseBody);
            return ObjectConvert.JSONToMap((String)responseBody).get("_id").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Override
    public void delete(String index, String id) {
        if (StringUtils.isEmpty((Object)index)) {
            throw new RuntimeException("index must not be empty");
        }
        if (StringUtils.isEmpty((Object)id)) {
            throw new RuntimeException("id must not be null");
        }
        try {
            Request request = new Request("DELETE", "/" + index + "/_doc/" + id);
            request.addParameter("pretty", "true");
            Response response = this.highLevelClient.getLowLevelClient().performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("ResponseBody: ", (Object)responseBody);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void update(String index, String id, Object doc) {
        if (StringUtils.isEmpty((Object)index)) {
            throw new RuntimeException("index must not be empty");
        }
        if (StringUtils.isEmpty((Object)id)) {
            throw new RuntimeException("id must not be null");
        }
        try {
            Request request = new Request("POST", "/" + index + "/_doc/" + id + "/_update");
            request.addParameter("pretty", "true");
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            jsonObject.put("doc", doc);
            request.setEntity((HttpEntity)new NStringEntity(ObjectConvert.toJSONString(jsonObject), ContentType.APPLICATION_JSON));
            Response response = this.highLevelClient.getLowLevelClient().performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info(responseBody);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u66f4\u65b0\u5931\u8d25");
        }
    }

    @Override
    public <T> T search(String index, String id, Class<T> clazz) {
        Request request = new Request("GET", "/" + index + "/_doc/" + id);
        request.addParameter("pretty", "true");
        try {
            Response response = this.highLevelClient.getLowLevelClient().performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return (T)ObjectConvert.convert(ObjectConvert.JSONToMap((String)responseBody).get("_source"), clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long count(String index, QueryBuilder queryBuilder) {
        CountRequest countRequest = new CountRequest(new String[]{index});
        if (queryBuilder != null) {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query(queryBuilder);
            countRequest.source(sourceBuilder);
        }
        try {
            CountResponse response = this.highLevelClient.count(countRequest, RequestOptions.DEFAULT);
            return response.getCount();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

