/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.security.jwt;

import com.pcauto.lib.security.jwt.TokenProvider;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class JWTFilter
extends GenericFilterBean {
    private final Logger log = LoggerFactory.getLogger(JWTFilter.class);
    private TokenProvider tokenProvider;

    public JWTFilter(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String jwt = this.resolveToken(httpServletRequest);
            if (StringUtils.hasText((String)jwt) && this.tokenProvider.validateToken(jwt)) {
                Authentication authentication = this.tokenProvider.getAuthentication(jwt);
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (ExpiredJwtException eje) {
            this.log.info("Security exception for user {} - {}", (Object)eje.getClaims().getSubject(), (Object)eje.getMessage());
            this.log.trace("Security exception trace: {}", (Throwable)eje);
            ((HttpServletResponse)servletResponse).setStatus(401);
        }
    }

    private String resolveToken(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7, bearerToken.length());
        }
        String jwt = request.getParameter("access_token");
        if (StringUtils.hasText((String)jwt)) {
            return jwt;
        }
        return null;
    }
}

