package com.pcauto.lib.security.config;


import com.pcauto.lib.security.AbstractWebSecurityConfig;
import com.pcauto.lib.security.jwt.JWTConfigurer;
import com.pcauto.lib.security.jwt.TimeProvider;
import com.pcauto.lib.security.jwt.TokenProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;

/**
 * @author henry
 */
@Configuration
public class JWTWebSecurityConfig extends AbstractWebSecurityConfig {

    @Bean
    TokenProvider tokenProvider() {
        return new TokenProvider();
    }

    @Bean
    TimeProvider timeProvider() {
        return new TimeProvider();
    }

    @Bean
    JWTConfigurer jwtConfigurer() {
        return new JWTConfigurer();
    }

    // 从IOC容器中获取 JWTConfigurer，确保为同一个实例对象
    @Autowired
    private  JWTConfigurer jwtConfigurer;

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        http.apply(jwtConfigurer);
    }
}
