/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.wx.ma.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisConfigImpl;
import com.pcauto.lib.wx.ma.config.RedisProperties;
import com.pcauto.lib.wx.ma.config.WxMaProperties;
import com.pcauto.lib.wx.ma.service.WxMaBaseService;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={WxMaProperties.class})
public class WxMaConfiguration {
    @Autowired
    private WxMaBaseService wxMaBaseService;
    @Autowired
    private WxMaProperties wxMaProperties;

    @Bean
    WxMaService wxMaService() {
        if (this.wxMaBaseService == null) {
            throw new RuntimeException("=============>>> \u5927\u54e5,\u4f60\u5fd8\u8bb0\u5b9e\u73b0WxMaBaseService\u4e86 <<<=============");
        }
        WxMaServiceImpl service = new WxMaServiceImpl();
        if (this.wxMaProperties.getRedis() != null) {
            RedisProperties redisProperties = this.wxMaProperties.getRedis();
            JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)redisProperties, redisProperties.getHost(), redisProperties.getPort(), redisProperties.getConnectionTimeout(), redisProperties.getSoTimeout(), redisProperties.getPassword(), redisProperties.getDatabase(), redisProperties.getClientName(), redisProperties.isSsl(), redisProperties.getSslSocketFactory(), redisProperties.getSslParameters(), redisProperties.getHostnameVerifier());
            WxMaRedisConfigImpl config = new WxMaRedisConfigImpl();
            config.setAppid(this.wxMaProperties.getAppid());
            config.setSecret(this.wxMaProperties.getSecret());
            config.setToken(this.wxMaProperties.getToken());
            config.setAesKey(this.wxMaProperties.getAesKey());
            config.setMsgDataFormat(this.wxMaProperties.getMsgDataFormat());
            config.setMaId(this.wxMaProperties.getAppid());
            config.setJedisPool(jedisPool);
            service.setWxMaConfig((WxMaConfig)config);
        } else {
            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
            config.setAppid(this.wxMaProperties.getAppid());
            config.setSecret(this.wxMaProperties.getSecret());
            config.setToken(this.wxMaProperties.getToken());
            config.setAesKey(this.wxMaProperties.getAesKey());
            config.setMsgDataFormat(this.wxMaProperties.getMsgDataFormat());
            service.setWxMaConfig((WxMaConfig)config);
        }
        return service;
    }
}

