/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.pcauto.lib.core.mvc.error.CodedException;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.service.WxMaBaseService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class WxMaDecodeService {
    @Autowired
    private WxMaService wxMaService;
    @Autowired
    private WxMaBaseService wxMaBaseService;

    public GenericResponse<WxMaUserInfo> userInfo(String signature, String rawData, String encryptedData, String iv) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = this.wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty((CharSequence)sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }
        if (!this.wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new CodedException(40002, "user check failed");
        }
        WxMaUserInfo userInfo = this.wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
        return new GenericResponse((Object)userInfo);
    }

    public GenericResponse<WxMaPhoneNumberInfo> phone(String signature, String rawData, String encryptedData, String iv) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = this.wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty((CharSequence)sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }
        if (!this.wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new CodedException(40001, "user check failed");
        }
        WxMaPhoneNumberInfo phoneNoInfo = this.wxMaService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);
        return new GenericResponse((Object)phoneNoInfo);
    }
}

