package com.pcauto.lib.wx.ma.api;

import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.dto.WxMaFormIdDto;
import com.pcauto.lib.wx.ma.pojo.WxMaTemplateMsgRequest;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

/**
 * @author sam
 * @since 2019/8/8
 */
public interface WxMaApi {

    /**
     * 提交formId
     *
     * @param appid
     * @param formIdDto
     * @return
     */
    @POST("/api/wx/ma/{appid}/base/formId")
    Call<GenericResponse> saveFormId(@Path("appid") String appid,
                                     @Body WxMaFormIdDto formIdDto);

    /**
     * 向单个用户发送模板消息
     *
     * @param appid
     * @param accessToken
     * @param vm          模板消息发送数据
     * @return
     */
    @POST("/api/wx/ma/{appid}/template/message/send/single")
    Call<GenericResponse> sendTemplateMsgToSingle(@Path("appid") String appid,
                                                  @Query("accessToken") String accessToken,
                                                  @Body WxMaTemplateMsgRequest.Single vm);

    /**
     * 向所有用户发送模板消息
     *
     * @param appid
     * @param accessToken
     * @param vm          模板消息发送数据
     * @return
     */
    @POST("/api/wx/ma/{appid}/template/message/send/all")
    Call<GenericResponse> sendTemplateMsgToAll(@Path("appid") String appid,
                                               @Query("accessToken") String accessToken,
                                               @Body WxMaTemplateMsgRequest.Base vm);

}
