package com.pcauto.lib.wx.ma.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pcauto.lib.core.config.ProxyPropertie;
import com.pcauto.lib.wx.ma.api.WxMaApi;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

import java.net.InetSocketAddress;
import java.net.Proxy;

/**
 * @author Sam
 */
@Configuration
@EnableConfigurationProperties(WxMaProperties.class)
public class WxMaApiConfig {

    @Autowired
    private WxMaProperties wxMaProperties;

    @Autowired
    private ProxyPropertie proxyPropertie;

    @Bean
    WxMaApi wxMaApi() {

        if (StringUtils.isBlank(wxMaProperties.getWxServerUrl())) {
            return null;
        }
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(wxMaProperties.getWxServerUrl())
                .client(okHttpClient())
                .addConverterFactory(JacksonConverterFactory.create(new ObjectMapper()))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .build();
        return retrofit.create(WxMaApi.class);
    }

    private OkHttpClient okHttpClient() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        if (proxyPropertie.isEnable()) {
            return new OkHttpClient.Builder()
                    .addInterceptor(loggingInterceptor)
                    .proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyPropertie.getHost(), proxyPropertie.getPort())))
                    .build();
        }
        return new OkHttpClient.Builder()
                .addInterceptor(loggingInterceptor)
                .build();
    }

}
