package com.pcauto.lib.wx.ma.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisConfigImpl;
import com.pcauto.lib.core.config.ProxyPropertie;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * @author sam
 * @since 2019/8/19
 */
@Configuration
@EnableConfigurationProperties(WxMaProperties.class)
public class WxMaConfiguration {

    @Autowired
    private WxMaProperties wxMaProperties;

    @Autowired
    ProxyPropertie proxyPropertie;

    @Bean
    WxMaService wxMaService() {

        WxMaService service = new WxMaServiceImpl();
        if (wxMaProperties.getRedis() != null) {
            RedisProperties redisProperties = wxMaProperties.getRedis();
            JedisPool jedisPool = new JedisPool(redisProperties, redisProperties.getHost(),
                    redisProperties.getPort(), redisProperties.getConnectionTimeout(),
                    redisProperties.getSoTimeout(), redisProperties.getPassword(),
                    redisProperties.getDatabase(), redisProperties.getClientName(),
                    redisProperties.isSsl(), redisProperties.getSslSocketFactory(),
                    redisProperties.getSslParameters(), redisProperties.getHostnameVerifier());

            WxMaRedisConfigImpl config = new WxMaRedisConfigImpl();
            if (proxyPropertie.isEnable()) {
                config.setHttpProxyHost(proxyPropertie.getHost());
                config.setHttpProxyPort(proxyPropertie.getPort());
            }
            config.setAppid(wxMaProperties.getAppid());
            config.setSecret(wxMaProperties.getSecret());
            config.setToken(wxMaProperties.getToken());
            config.setAesKey(wxMaProperties.getAesKey());
            config.setMsgDataFormat(wxMaProperties.getMsgDataFormat());
            config.setMaId(wxMaProperties.getAppid());
            config.setJedisPool(jedisPool);
            service.setWxMaConfig(config);
        } else {
            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
            if (proxyPropertie.isEnable()) {
                config.setHttpProxyHost(proxyPropertie.getHost());
                config.setHttpProxyPort(proxyPropertie.getPort());
            }
            config.setAppid(wxMaProperties.getAppid());
            config.setSecret(wxMaProperties.getSecret());
            config.setToken(wxMaProperties.getToken());
            config.setAesKey(wxMaProperties.getAesKey());
            config.setMsgDataFormat(wxMaProperties.getMsgDataFormat());
            service.setWxMaConfig(config);
        }
        return service;
    }

}