package com.pcauto.lib.wx.ma.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author sam
 * @since 2019/8/19
 */
@Data
@ConfigurationProperties(prefix = "wx.ma")
public class WxMaProperties {

    /**
     * 设置微信小程序的appid
     */
    private String appid;

    /**
     * 设置微信小程序的Secret
     */
    private String secret;

    /**
     * 设置微信小程序消息服务器配置的token
     */
    private String token;

    /**
     * 设置微信小程序消息服务器配置的EncodingAESKey
     */
    private String aesKey;

    /**
     * 消息格式，XML或者JSON
     */
    private String msgDataFormat;

    /**
     * redis配置
     */
    private RedisProperties redis;

    /**
     * 微信服务url api-wx
     */
    private String wxServerUrl;

}
