package com.pcauto.lib.wx.ma.controller;

import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.vo.WxMaLoginVo;
import com.pcauto.lib.wx.ma.service.WxMaAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信小程序授权相关接口
 *
 * @author Sam
 */
@RestController
@RequestMapping("/wx/ma/auth")
@Api(tags = "[小程序] 授权接口")
public class WxMaAuthController {

    @Autowired
    private WxMaAuthService authService;

    @ApiOperation(value = "微信小程序登录", notes = "微信小程序登录")
    @GetMapping("/login")
    public GenericResponse<WxMaLoginVo> login(@ApiParam(value = "wx.login获得临时登录凭证") @RequestParam String code) {
        return authService.login(code);
    }

    @ApiOperation(value = "微信小程序退出登录", notes = "微信小程序退出登录")
    @GetMapping("/logout")
    public GenericResponse<String> logout() {
        return authService.logout();
    }

}
