package com.pcauto.lib.wx.ma.controller;

import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.dto.WxMaFormIdDto;
import com.pcauto.lib.wx.ma.service.WxMaTemplateMsgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信小程序基础接口
 *
 * @author Sam
 */
@RestController
@RequestMapping("/wx/ma/base")
@Api(tags = "[小程序] 基础接口")
public class WxMaBaseController {

    @Autowired
    private WxMaTemplateMsgService wxMaTemplateMsgService;

    @ApiOperation(value = "提交formId", notes = "提交formId,用于模板消息发送")
    @PostMapping("/formId")
    public GenericResponse saveFormId(@ApiParam(value = "formIdDto") @RequestBody @Validated WxMaFormIdDto formIdDto) {
        wxMaTemplateMsgService.saveFormId(formIdDto);
        return new GenericResponse<>();
    }

}
