package com.pcauto.lib.wx.ma.controller;

import com.pcauto.lib.wx.ma.service.WxMaCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 微信小程序小程序码相关接口
 *
 * @author Sam
 */
@RestController
@RequestMapping("/wx/ma/code")
@Api(tags = "[小程序] 小程序码接口")
public class WxMaCodeController {

    @Autowired
    private WxMaCodeService codeService;

    @ApiOperation(value = "获取小程序二维码", notes = "获取小程序二维码，适用于需要的码数量较少的业务场景。通过该接口生成的小程序码，永久有效，有数量限制。\r\n 微信文档: https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.createQRCode.html")
    @GetMapping("/createQRCode")
    public void createQRCode(@ApiParam(value = "扫码进入的小程序页面路径，最大长度 128 字节，不能为空；可带参数，如：\"?foo=bar\"", required = true) @RequestParam String path,
                             @ApiParam(value = "二维码的宽度，单位 px; 默认:430") @RequestParam(defaultValue = "430", required = false) int width,
                             HttpServletResponse response) {
        codeService.createQRCode(path, width, response);
    }

    @ApiOperation(value = "获取小程序码(有限制)", notes = "获取小程序码，适用于需要的码数量较少的业务场景。通过该接口生成的小程序码，永久有效，有数量限制。\r\n 微信文档: https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.get.html")
    @GetMapping("/get")
    public void get(@ApiParam(value = "扫码进入的小程序页面路径，最大长度 128 字节，不能为空；可带参数，如：\"?foo=bar\"", required = true) @RequestParam String path,
                    @ApiParam(value = "二维码的宽度，单位 px; 默认:430") @RequestParam(defaultValue = "430", required = false) int width,
                    @ApiParam(value = "是否需要透明底色，为 true 时，生成透明底色的小程序码\n") @RequestParam(defaultValue = "false", required = false) boolean isHyaline,
                    HttpServletResponse response) {
        codeService.get(path, width, isHyaline, response);
    }

    @ApiOperation(value = "获取小程序码(无限制)", notes = "获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制。\r\n 微信文档: https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.getUnlimited.html")
    @GetMapping("/getUnlimited")
    public void getUnlimited(@ApiParam(value = "场景值") @RequestParam String scene,
                             @ApiParam(value = "页面,必须是已经发布的小程序存在的页面（否则报错）") @RequestParam(required = false) String page,
                             @ApiParam(value = "二维码的宽度，单位 px; 默认:430") @RequestParam(defaultValue = "430", required = false) int width,
                             @ApiParam(value = "是否需要透明底色，为 true 时，生成透明底色的小程序码\n") @RequestParam(defaultValue = "false", required = false) boolean isHyaline,
                             HttpServletResponse response) {
        codeService.getUnlimited(scene, page, width, isHyaline, response);
    }

}
