package com.pcauto.lib.wx.ma.controller;

import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaRunStepInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.service.WxMaDecodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 微信小程序数据解密相关接口
 *
 * @author Sam
 */
@RestController
@RequestMapping("/wx/ma/decode")
@Api(tags = "[小程序] 数据解密接口")
public class WxMaDecodeController {

    @Autowired
    private WxMaDecodeService decodeService;

    @ApiOperation(value = "解密用户信息", notes = "解密用户信息")
    @GetMapping("/userInfo")
    public GenericResponse<WxMaUserInfo> info(@ApiParam(value = "使用 sha1( rawData + sessionkey ) 得到字符串，用于校验用户信息") @RequestParam String signature,
                                              @ApiParam(value = "不包括敏感信息的原始数据字符串，用于计算签名") @RequestParam String rawData,
                                              @ApiParam(value = "包括敏感数据在内的完整用户信息的加密数据") @RequestParam String encryptedData,
                                              @ApiParam(value = "加密算法的初始向量") @RequestParam String iv) {
        return decodeService.userInfo(signature, rawData, encryptedData, iv);
    }

    @ApiOperation(value = "解密用户绑定手机号信息", notes = "解密用户绑定手机号信息")
    @GetMapping("/phone")
    public GenericResponse<WxMaPhoneNumberInfo> phone(@ApiParam(value = "包括敏感数据在内的完整用户信息的加密数据") @RequestParam String encryptedData,
                                                      @ApiParam(value = "加密算法的初始向量") @RequestParam String iv) {
        return decodeService.phone(encryptedData, iv);
    }

    @ApiOperation(value = "解密微信运动信息", notes = "解密微信运动信息")
    @GetMapping("/runData")
    public GenericResponse<List<WxMaRunStepInfo>> runData(@ApiParam(value = "包括敏感数据在内的完整用户信息的加密数据") @RequestParam String encryptedData,
                                                          @ApiParam(value = "加密算法的初始向量") @RequestParam String iv) {
        return decodeService.runData(encryptedData, iv);
    }

}
