package com.pcauto.lib.wx.ma.controller;

import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.service.WxMaSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 微信小程序内容安全接口
 *
 * @author Sam
 */
@RestController
@RequestMapping("/wx/ma/secCheck")
@Api(tags = "[小程序] 内容安全接口")
public class WxMaSecCheckController {

    @Autowired
    private WxMaSecurityService securityService;

    @ApiOperation(value = "文本内容检查", notes = "检查一段文本是否含有违法违规内容。返回值:true|false")
    @PostMapping("/msg")
    public GenericResponse<Boolean> msgSecCheck(@ApiParam(value = "msg", required = true) @RequestParam String msg) {
        return new GenericResponse<>(securityService.msgSecCheck(msg));
    }

    @ApiOperation(value = "图片检查", notes = "校验一张图片是否含有违法违规内容。返回值:true|false")
    @PostMapping(value = "/img", consumes = {MediaType.MULTIPART_FORM_DATA_VALUE})
    public GenericResponse<Boolean> imgSecCheck(@ApiParam(value = "file") @RequestPart MultipartFile file) {
        return new GenericResponse<>(securityService.imgSecCheck(file));
    }

}
