package com.pcauto.lib.wx.ma.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 微信小程序模板消息Dto
 *
 * @author sam
 * @since 2019/8/9
 */
public class WxMaTemplateMsgRequest {

    /**
     * 模板消息发送数据(基础)
     */
    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Base {

        /**
         * 所需下发的模板消息的id
         */
        private String templateId;

        /**
         * 点击模板卡片后的跳转页面
         */
        private String page;

        /**
         * 模板内容，不填则下发空模板
         */
        private List<MsgData> data;
    }

    /**
     * 模板消息内容
     */
    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MsgData {

        /**
         * 第几个关键词 如: keyword1
         */
        private String name;

        /**
         * 关键词内容 如: 穿越火线枪战王者职业联赛
         */
        private String value;

        /**
         * 字体颜色 如: #FF7F24
         */
        private String color;

    }

    /**
     * 模板消息发送数据(单个)
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Single extends Base {

        /**
         * 接收者（用户）的 openid
         */
        private String openId;
    }

    /**
     * 模板消息发送数据(多个)
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Mul extends Base {

        /**
         * 接收者（用户）的 openid 数组
         */
        private List<String> openIds;

    }


}
