package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaRunStepInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.pcauto.lib.wx.ma.vo.WxMaLoginVo;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 微信小程序基础service
 *
 * @author sam
 * @since 2019/9/6
 */
public interface WxMaBaseService {

    /**
     * 登录
     *
     * @param wxSession
     * @return 返回 登录信息
     */
    WxMaLoginVo login(WxMaJscode2SessionResult wxSession);

    /**
     * 退出登录
     *
     * @param request
     * @return
     */
    void logout(HttpServletRequest request);

    /**
     * 获取 sessionKey
     *
     * @param request
     * @return
     */
    String getSessionKey(HttpServletRequest request);

    /**
     * 处理用户信息解密
     *
     * @param userInfo
     */
    default void handleUserInfoDecode(WxMaUserInfo userInfo) {
    }

    /**
     * 处理手机号码解密
     *
     * @param phoneNoInfo
     */
    default void handlePhoneDecode(WxMaPhoneNumberInfo phoneNoInfo) {

    }

    /**
     * 处理微信运动信息解密
     *
     * @param wxMaRunStepInfos
     */
    default void handleRunDataDecode(List<WxMaRunStepInfo> wxMaRunStepInfos) {

    }

}
