package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import com.pcauto.lib.core.mvc.error.CodedException;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * <p>
 * 小程序小程序码service
 * </p>
 *
 * @author Sam
 * @since 2019-07-10
 */
@Service
public class WxMaCodeService {

    @Autowired
    private WxMaService wxMaService;

    /**
     * 获取小程序二维码，适用于需要的码数量较少的业务场景
     * <p>
     * 文档: https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.createQRCode.html
     *
     * @return
     */
    public void createQRCode(String path, int width, HttpServletResponse response) {
        try {
            response.getOutputStream().write(wxMaService.getQrcodeService().createQrcodeBytes(path, width));
        } catch (IOException e) {
            e.printStackTrace();
            throw new CodedException("获取失败");
        } catch (WxErrorException e) {
            e.printStackTrace();
            throw new CodedException("获取失败:" + e.getMessage());
        }
    }

    /**
     * 获取小程序码，适用于需要的码数量较少的业务场景。通过该接口生成的小程序码，永久有效，有数量限制
     * <p>
     * 文档: https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.get.html
     *
     * @param path
     * @param width
     * @param isHyaline
     * @param response
     */
    public void get(String path, int width, boolean isHyaline, HttpServletResponse response) {

        try {
            response.getOutputStream().write(wxMaService.getQrcodeService().createWxaCodeBytes(path, width, true, null, isHyaline));
        } catch (IOException e) {
            e.printStackTrace();
            throw new CodedException("获取失败");
        } catch (WxErrorException e) {
            e.printStackTrace();
            throw new CodedException("获取失败:" + e.getMessage());
        }
    }

    /**
     * 获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制。
     * <p>
     * 文档: https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/qr-code/wxacode.getUnlimited.html
     *
     * @param scene
     * @param page
     * @param width
     * @param isHyaline
     * @param response
     */
    public void getUnlimited(String scene, String page, int width, boolean isHyaline, HttpServletResponse response) {
        try {
            response.getOutputStream().write(wxMaService.getQrcodeService().createWxaCodeUnlimitBytes(scene, page, width, true, null, isHyaline));
        } catch (IOException e) {
            e.printStackTrace();
            throw new CodedException("获取失败");
        } catch (WxErrorException e) {
            e.printStackTrace();
            throw new CodedException("获取失败:" + e.getMessage());
        }
    }

}
