package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaRunStepInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.pcauto.lib.core.mvc.error.CodedException;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * <p>
 * 小程序数据解密service
 * </p>
 *
 * @author Sam
 * @since 2019-07-10
 */
@Service
public class WxMaDecodeService {

    @Autowired
    private WxMaService wxMaService;

    @Autowired(required = false)
    private WxMaBaseService wxMaBaseService;

    /**
     * 获取用户信息
     * <p>
     * 文档: https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/signature.html#method-decode
     *
     * @param signature
     * @param rawData
     * @param encryptedData
     * @param iv
     * @return
     */
    public GenericResponse<WxMaUserInfo> userInfo(String signature, String rawData, String encryptedData, String iv) {

        if (wxMaBaseService == null) {
            throw new RuntimeException("=============>>> 大哥,你忘记实现WxMaBaseService了 <<<=============");
        }

        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty(sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }

        // 用户信息校验
        if (!wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new CodedException(40002, "user check failed");
        }

        // 解密用户信息
        WxMaUserInfo userInfo = wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
        wxMaBaseService.handleUserInfoDecode(userInfo);
        return new GenericResponse(userInfo);
    }


    /**
     * 获取用户绑定手机号信息
     * <p>
     * 文档: https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/getPhoneNumber.html
     *
     * @param encryptedData
     * @param iv
     * @return
     */
    public GenericResponse<WxMaPhoneNumberInfo> phone(String encryptedData, String iv) {

        if (wxMaBaseService == null) {
            throw new RuntimeException("=============>>> 大哥,你忘记实现WxMaBaseService了 <<<=============");
        }

        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty(sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }

        // 解密
        WxMaPhoneNumberInfo phoneNoInfo = wxMaService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);
        wxMaBaseService.handlePhoneDecode(phoneNoInfo);
        return new GenericResponse(phoneNoInfo);
    }


    /**
     * 解密微信运动信息
     * <p>
     * 文档：https://developers.weixin.qq.com/miniprogram/dev/api/open-api/werun/wx.getWeRunData.html
     *
     * @param encryptedData
     * @param iv
     * @return
     */
    public GenericResponse<List<WxMaRunStepInfo>> runData(String encryptedData, String iv) {

        if (wxMaBaseService == null) {
            throw new RuntimeException("=============>>> 大哥,你忘记实现WxMaBaseService了 <<<=============");
        }

        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty(sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }

        // 解密
        List<WxMaRunStepInfo> wxMaRunStepInfos = wxMaService.getRunService().getRunStepInfo(sessionKey, encryptedData, iv);
        wxMaBaseService.handleRunDataDecode(wxMaRunStepInfos);
        return new GenericResponse(wxMaRunStepInfos);
    }

}
