package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.UUID;

/**
 * @author sam
 * @since 2019/10/11
 */
@Service
public class WxMaSecurityService {

    @Autowired
    private WxMaService wxMaService;

    /**
     * 图片校验
     *
     * @param multipartFile
     */
    public Boolean imgSecCheck(MultipartFile multipartFile) {
        if (multipartFile.isEmpty()) {
            return true;
        }
        String fileName = UUID.randomUUID() + "_" + multipartFile.getOriginalFilename();
        File file = new File(fileName);
        try {
            FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), file);
            return wxMaService.getSecCheckService().checkImage(file);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        } finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    /**
     * 文本校验
     *
     * @param msg
     * @return
     */
    public Boolean msgSecCheck(String msg) {
        if (StringUtils.isEmpty(msg)) {
            return true;
        }
        return wxMaService.getSecCheckService().checkMessage(msg);
    }

}
