package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import com.pcauto.lib.core.mvc.error.CodedException;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.api.WxMaApi;
import com.pcauto.lib.wx.ma.dto.WxMaFormIdDto;
import com.pcauto.lib.wx.ma.pojo.WxMaTemplateMsgRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import retrofit2.Call;

import java.io.IOException;

/**
 * 模板消息服务
 *
 * @author sam
 * @since 2019/7/10
 */
@Service
public class WxMaTemplateMsgService {

    @Autowired
    private WxMaService wxMaService;

    @Autowired(required = false)
    private WxMaApi wxMaApi;

    /**
     * 保存formId
     *
     * @param formIdDto
     */
    public void saveFormId(WxMaFormIdDto formIdDto) {
        if (wxMaApi == null) {
            throw new RuntimeException("请配置 wx.ma.wxServerUrl");
        }
        Call<GenericResponse> call = wxMaApi.saveFormId(wxMaService.getWxMaConfig().getAppid(), formIdDto);
        try {
            if (!call.execute().isSuccessful()) {
                throw new CodedException("保存失败[wx服务异常]");
            }
        } catch (IOException e) {
            throw new CodedException("保存失败");
        }
    }

    /**
     * 向单个用户发送模板消息
     *
     * @param openId 用户openId
     * @param wm
     * @return
     */
    public void sendTemplateMsgToSingle(String openId, WxMaTemplateMsgRequest.Base wm) {
        if (wxMaApi == null) {
            throw new RuntimeException("请配置 wx.ma.wxServerUrl");
        }
        WxMaTemplateMsgRequest.Single single = new WxMaTemplateMsgRequest.Single();
        single.setOpenId(openId);
        single.setTemplateId(wm.getTemplateId());
        single.setPage(wm.getPage());
        single.setData(wm.getData());
        try {
            Call<GenericResponse> call = wxMaApi.sendTemplateMsgToSingle(wxMaService.getWxMaConfig().getAppid(), wxMaService.getAccessToken(), single);
            if (!call.execute().isSuccessful()) {
                throw new CodedException("发送失败[wx服务异常]");
            }
        } catch (Exception e) {
            throw new CodedException("发送失败");
        }
    }

    /**
     * 向所有可达用户发送模板消息
     *
     * @param wm
     * @return
     */
    public void sendTemplateMsgToAll(WxMaTemplateMsgRequest.Base wm) {

        if (wxMaApi == null) {
            throw new RuntimeException("请配置 wx.ma.wxServerUrl");
        }
        try {
            Call<GenericResponse> call = wxMaApi.sendTemplateMsgToAll(wxMaService.getWxMaConfig().getAppid(), wxMaService.getAccessToken(), wm);
            if (!call.execute().isSuccessful()) {
                throw new CodedException("发送失败[wx服务异常]");
            }
        } catch (Exception e) {
            throw new CodedException("发送失败");
        }

    }


}
