/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.wx.ma.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pcauto.lib.core.config.ProxyPropertie;
import com.pcauto.lib.wx.ma.api.WxMaApi;
import com.pcauto.lib.wx.ma.config.WxMaProperties;
import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@EnableConfigurationProperties(value={WxMaProperties.class})
public class WxMaApiConfig {
    @Autowired
    private WxMaProperties wxMaProperties;
    @Autowired
    private ProxyPropertie proxyPropertie;

    @Bean
    WxMaApi wxMaApi() {
        if (StringUtils.isBlank((CharSequence)this.wxMaProperties.getWxServerUrl())) {
            return null;
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.wxMaProperties.getWxServerUrl()).client(this.okHttpClient()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)new ObjectMapper())).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
        return (WxMaApi)retrofit.create(WxMaApi.class);
    }

    private OkHttpClient okHttpClient() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        if (this.proxyPropertie.isEnable()) {
            return new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyPropertie.getHost(), this.proxyPropertie.getPort()))).build();
        }
        return new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).build();
    }
}

