/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.wx.ma.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaRedisConfigImpl;
import com.pcauto.lib.core.config.ProxyPropertie;
import com.pcauto.lib.wx.ma.config.RedisProperties;
import com.pcauto.lib.wx.ma.config.WxMaProperties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={WxMaProperties.class})
public class WxMaConfiguration {
    @Autowired
    private WxMaProperties wxMaProperties;
    @Autowired
    ProxyPropertie proxyPropertie;

    @Bean
    WxMaService wxMaService() {
        WxMaServiceImpl service = new WxMaServiceImpl();
        if (this.wxMaProperties.getRedis() != null) {
            RedisProperties redisProperties = this.wxMaProperties.getRedis();
            JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)redisProperties, redisProperties.getHost(), redisProperties.getPort(), redisProperties.getConnectionTimeout(), redisProperties.getSoTimeout(), redisProperties.getPassword(), redisProperties.getDatabase(), redisProperties.getClientName(), redisProperties.isSsl(), redisProperties.getSslSocketFactory(), redisProperties.getSslParameters(), redisProperties.getHostnameVerifier());
            WxMaRedisConfigImpl config = new WxMaRedisConfigImpl();
            if (this.proxyPropertie.isEnable()) {
                config.setHttpProxyHost(this.proxyPropertie.getHost());
                config.setHttpProxyPort(this.proxyPropertie.getPort());
            }
            config.setAppid(this.wxMaProperties.getAppid());
            config.setSecret(this.wxMaProperties.getSecret());
            config.setToken(this.wxMaProperties.getToken());
            config.setAesKey(this.wxMaProperties.getAesKey());
            config.setMsgDataFormat(this.wxMaProperties.getMsgDataFormat());
            config.setMaId(this.wxMaProperties.getAppid());
            config.setJedisPool(jedisPool);
            service.setWxMaConfig((WxMaConfig)config);
        } else {
            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
            if (this.proxyPropertie.isEnable()) {
                config.setHttpProxyHost(this.proxyPropertie.getHost());
                config.setHttpProxyPort(this.proxyPropertie.getPort());
            }
            config.setAppid(this.wxMaProperties.getAppid());
            config.setSecret(this.wxMaProperties.getSecret());
            config.setToken(this.wxMaProperties.getToken());
            config.setAesKey(this.wxMaProperties.getAesKey());
            config.setMsgDataFormat(this.wxMaProperties.getMsgDataFormat());
            service.setWxMaConfig((WxMaConfig)config);
        }
        return service;
    }
}

