/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import com.pcauto.lib.core.mvc.error.CodedException;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.service.WxMaBaseService;
import com.pcauto.lib.wx.ma.vo.WxMaLoginVo;
import javax.servlet.http.HttpServletRequest;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class WxMaAuthService {
    @Autowired
    private WxMaService wxMaService;
    @Autowired(required=false)
    private WxMaBaseService wxMaBaseService;

    public String getAccessToken() {
        try {
            return this.wxMaService.getAccessToken();
        }
        catch (WxErrorException e) {
            throw new CodedException(e.getError().getErrorCode(), e.getError().getErrorMsg());
        }
    }

    public GenericResponse<WxMaLoginVo> login(String code) {
        if (this.wxMaBaseService == null) {
            throw new RuntimeException("=============>>> \u5927\u54e5,\u4f60\u5fd8\u8bb0\u5b9e\u73b0WxMaBaseService\u4e86 <<<=============");
        }
        WxMaLoginVo login = this.wxMaBaseService.login(this.code2Session(code));
        if (login == null || StringUtils.isEmpty((CharSequence)login.getToken())) {
            throw new CodedException(40002, "\u767b\u5f55\u5931\u8d25");
        }
        return new GenericResponse(1, "\u767b\u5f55\u6210\u529f", (Object)login);
    }

    public GenericResponse<String> logout() {
        if (this.wxMaBaseService == null) {
            throw new RuntimeException("=============>>> \u5927\u54e5,\u4f60\u5fd8\u8bb0\u5b9e\u73b0WxMaBaseService\u4e86 <<<=============");
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.wxMaBaseService.logout(request);
        return new GenericResponse();
    }

    public WxMaJscode2SessionResult code2Session(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new CodedException(40001, "code \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return this.wxMaService.getUserService().getSessionInfo(code);
        }
        catch (WxErrorException e) {
            throw new CodedException(e.getError().getErrorCode(), e.getError().getErrorMsg());
        }
    }
}

