/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaRunStepInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.pcauto.lib.core.mvc.error.CodedException;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.service.WxMaBaseService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class WxMaDecodeService {
    @Autowired
    private WxMaService wxMaService;
    @Autowired(required=false)
    private WxMaBaseService wxMaBaseService;

    public GenericResponse<WxMaUserInfo> userInfo(String signature, String rawData, String encryptedData, String iv) {
        if (this.wxMaBaseService == null) {
            throw new RuntimeException("=============>>> \u5927\u54e5,\u4f60\u5fd8\u8bb0\u5b9e\u73b0WxMaBaseService\u4e86 <<<=============");
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = this.wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty((CharSequence)sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }
        if (!this.wxMaService.getUserService().checkUserInfo(sessionKey, rawData, signature)) {
            throw new CodedException(40002, "user check failed");
        }
        WxMaUserInfo userInfo = this.wxMaService.getUserService().getUserInfo(sessionKey, encryptedData, iv);
        this.wxMaBaseService.handleUserInfoDecode(userInfo);
        return new GenericResponse((Object)userInfo);
    }

    public GenericResponse<WxMaPhoneNumberInfo> phone(String encryptedData, String iv) {
        if (this.wxMaBaseService == null) {
            throw new RuntimeException("=============>>> \u5927\u54e5,\u4f60\u5fd8\u8bb0\u5b9e\u73b0WxMaBaseService\u4e86 <<<=============");
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = this.wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty((CharSequence)sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }
        WxMaPhoneNumberInfo phoneNoInfo = this.wxMaService.getUserService().getPhoneNoInfo(sessionKey, encryptedData, iv);
        this.wxMaBaseService.handlePhoneDecode(phoneNoInfo);
        return new GenericResponse((Object)phoneNoInfo);
    }

    public GenericResponse<List<WxMaRunStepInfo>> runData(String encryptedData, String iv) {
        if (this.wxMaBaseService == null) {
            throw new RuntimeException("=============>>> \u5927\u54e5,\u4f60\u5fd8\u8bb0\u5b9e\u73b0WxMaBaseService\u4e86 <<<=============");
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String sessionKey = this.wxMaBaseService.getSessionKey(request);
        if (StringUtils.isEmpty((CharSequence)sessionKey)) {
            throw new CodedException(40001, "sessionKey empty");
        }
        List wxMaRunStepInfos = this.wxMaService.getRunService().getRunStepInfo(sessionKey, encryptedData, iv);
        this.wxMaBaseService.handleRunDataDecode(wxMaRunStepInfos);
        return new GenericResponse((Object)wxMaRunStepInfos);
    }
}

