/*
 * Decompiled with CFR 0.152.
 */
package com.pcauto.lib.wx.ma.service;

import cn.binarywang.wx.miniapp.api.WxMaService;
import com.pcauto.lib.core.mvc.error.CodedException;
import com.pcauto.lib.core.mvc.vo.GenericResponse;
import com.pcauto.lib.wx.ma.api.WxMaApi;
import com.pcauto.lib.wx.ma.dto.WxMaFormIdDto;
import com.pcauto.lib.wx.ma.pojo.WxMaTemplateMsgRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import retrofit2.Call;

@Service
public class WxMaTemplateMsgService {
    @Autowired
    private WxMaService wxMaService;
    @Autowired(required=false)
    private WxMaApi wxMaApi;

    public void saveFormId(WxMaFormIdDto formIdDto) {
        if (this.wxMaApi == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6e wx.ma.wxServerUrl");
        }
        Call<GenericResponse> call = this.wxMaApi.saveFormId(this.wxMaService.getWxMaConfig().getAppid(), formIdDto);
        try {
            if (!call.execute().isSuccessful()) {
                throw new CodedException("\u4fdd\u5b58\u5931\u8d25[wx\u670d\u52a1\u5f02\u5e38]");
            }
        }
        catch (IOException e) {
            throw new CodedException("\u4fdd\u5b58\u5931\u8d25");
        }
    }

    public void sendTemplateMsgToSingle(String openId, WxMaTemplateMsgRequest.Base wm) {
        if (this.wxMaApi == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6e wx.ma.wxServerUrl");
        }
        WxMaTemplateMsgRequest.Single single = new WxMaTemplateMsgRequest.Single();
        single.setOpenId(openId);
        single.setTemplateId(wm.getTemplateId());
        single.setPage(wm.getPage());
        single.setData(wm.getData());
        try {
            Call<GenericResponse> call = this.wxMaApi.sendTemplateMsgToSingle(this.wxMaService.getWxMaConfig().getAppid(), this.wxMaService.getAccessToken(), single);
            if (!call.execute().isSuccessful()) {
                throw new CodedException("\u53d1\u9001\u5931\u8d25[wx\u670d\u52a1\u5f02\u5e38]");
            }
        }
        catch (Exception e) {
            throw new CodedException("\u53d1\u9001\u5931\u8d25");
        }
    }

    public void sendTemplateMsgToAll(WxMaTemplateMsgRequest.Base wm) {
        if (this.wxMaApi == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6e wx.ma.wxServerUrl");
        }
        try {
            Call<GenericResponse> call = this.wxMaApi.sendTemplateMsgToAll(this.wxMaService.getWxMaConfig().getAppid(), this.wxMaService.getAccessToken(), wm);
            if (!call.execute().isSuccessful()) {
                throw new CodedException("\u53d1\u9001\u5931\u8d25[wx\u670d\u52a1\u5f02\u5e38]");
            }
        }
        catch (Exception e) {
            throw new CodedException("\u53d1\u9001\u5931\u8d25");
        }
    }
}

