package com.pcauto.lib.wx.pay.service;

import com.github.binarywang.wxpay.bean.entpay.EntPayRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.pcauto.lib.wx.pay.pojo.SkrWxEntPayRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 微信企业付款
 *
 * @author sam
 * @since 2019/9/23
 */
@Service
public class SkrWxEntPayService {

    @Autowired
    private WxPayService wxService;

    /**
     * 企业付款到零钱
     *
     * <pre>
     * 企业付款业务是基于微信支付商户平台的资金管理能力，为了协助商户方便地实现企业向个人付款，针对部分有开发能力的商户，提供通过API完成企业付款的功能。
     * 比如目前的保险行业向客户退保、给付、理赔。
     * 企业付款将使用商户的可用余额，需确保可用余额充足。查看可用余额、充值、提现请登录商户平台“资金管理”https://pay.weixin.qq.com/进行操作。
     * 注意：与商户微信支付收款资金并非同一账户，需要单独充值。
     * 文档详见:https://pay.weixin.qq.com/wiki/doc/api/tools/mch_pay.php?chapter=14_2
     * 接口链接：https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers
     * </pre>
     *
     * @param request 请求对象
     */
    public EntPayResult entPay(SkrWxEntPayRequest request) throws WxPayException {
        EntPayRequest entPayRequest = new EntPayRequest();
        BeanUtils.copyProperties(request, entPayRequest);
        return this.wxService.getEntPayService().entPay(entPayRequest);
    }

}
