/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.api.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcgroup.framework.common.entity.IRestCode;
import com.pcgroup.framework.common.entity.RestCode;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AdminResponse<T> {
    private String code;
    private String msg;
    private T data;
    private Integer count;

    public static AdminResponse<Void> success() {
        return AdminResponse.success(RestCode.SUCCESS);
    }

    public static AdminResponse<Void> success(IRestCode restCode) {
        return AdminResponse.success(restCode, null);
    }

    public static <T> AdminResponse<T> success(T data) {
        return AdminResponse.success((IRestCode)RestCode.SUCCESS, data);
    }

    public static <T> AdminResponse<T> success(IRestCode restCode, T data) {
        return AdminResponse.success(restCode.getCode(), restCode.getMessage(), data);
    }

    public static AdminResponse<Void> success(String code, String msg) {
        return AdminResponse.success(code, msg, null);
    }

    public static <T> AdminResponse<T> success(String code, String msg, T data) {
        return AdminResponse.builder().build().setCode(code).setMsg(msg).setData(data);
    }

    public static AdminResponse<Void> successCode(String code) {
        return AdminResponse.successCode(code, null);
    }

    public static <T> AdminResponse<T> successCode(String code, T data) {
        return AdminResponse.success(code, RestCode.SUCCESS.getMessage(), data);
    }

    public static AdminResponse<Void> successMessage(String msg) {
        return AdminResponse.successMessage(msg, null);
    }

    public static <T> AdminResponse<T> successMessage(String msg, T data) {
        return AdminResponse.success(RestCode.SUCCESS.getCode(), msg, data);
    }

    public static AdminResponse<Void> error() {
        return AdminResponse.error(RestCode.FAILURE);
    }

    public static AdminResponse<Void> error(IRestCode restCode) {
        return AdminResponse.error(restCode.getCode(), restCode.getMessage());
    }

    public static <T> AdminResponse<T> error(T data) {
        return AdminResponse.error((IRestCode)RestCode.FAILURE, data);
    }

    public static <T> AdminResponse<T> error(IRestCode restCode, T data) {
        return AdminResponse.error(restCode.getCode(), restCode.getMessage(), data);
    }

    public static AdminResponse<Void> error(String code, String msg) {
        return AdminResponse.error(code, msg, null);
    }

    public static <T> AdminResponse<T> error(String code, String msg, T data) {
        return AdminResponse.builder().build().setCode(code).setMsg(msg).setData(data);
    }

    public static AdminResponse<Void> errorCode(String code) {
        return AdminResponse.errorCode(code, null);
    }

    public static <T> AdminResponse<T> errorCode(String code, T data) {
        return AdminResponse.error(code, RestCode.FAILURE.getMessage(), data);
    }

    public static AdminResponse<Void> errorMessage(String msg) {
        return AdminResponse.errorMessage(msg, null);
    }

    public static <T> AdminResponse<T> errorMessage(String msg, T body) {
        return AdminResponse.error(RestCode.FAILURE.getCode(), msg, body);
    }

    public AdminResponse<T> mutate(IRestCode restCode) {
        this.setCode(restCode.getCode());
        this.setMsg(restCode.getMessage());
        return this;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return RestCode.SUCCESS.getCode().equals(this.getCode());
    }

    @JsonIgnore
    public boolean isError() {
        return !this.isSuccess();
    }

    public static <T> AdminResponseBuilder<T> builder() {
        return new AdminResponseBuilder();
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Integer getCount() {
        return this.count;
    }

    public AdminResponse<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public AdminResponse<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public AdminResponse<T> setData(T data) {
        this.data = data;
        return this;
    }

    public AdminResponse<T> setCount(Integer count) {
        this.count = count;
        return this;
    }

    public AdminResponse() {
    }

    public AdminResponse(String code, String msg, T data, Integer count) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.count = count;
    }

    public static class AdminResponseBuilder<T> {
        private String code;
        private String msg;
        private T data;
        private Integer count;

        AdminResponseBuilder() {
        }

        public AdminResponseBuilder<T> code(String code) {
            this.code = code;
            return this;
        }

        public AdminResponseBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public AdminResponseBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public AdminResponseBuilder<T> count(Integer count) {
            this.count = count;
            return this;
        }

        public AdminResponse<T> build() {
            return new AdminResponse<T>(this.code, this.msg, this.data, this.count);
        }

        public String toString() {
            return "AdminResponse.AdminResponseBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ", count=" + this.count + ")";
        }
    }
}

