/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.api.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcgroup.framework.common.entity.IRestCode;
import java.time.Instant;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResponseHead {
    private String requestId;
    private String code;
    private String message;
    private Long timestamp;
    private Long taketime;
    private String encoding;
    private Boolean success;
    private Boolean error;

    public static ResponseHead success(IRestCode restCode) {
        return ResponseHead.success(restCode.getCode(), restCode.getMessage());
    }

    public static ResponseHead success(String code, String message) {
        return ResponseHead.builder().build().setCode(code).setMessage(message).setTimestamp(Instant.now().toEpochMilli()).setSuccess(true).setError(false);
    }

    public static ResponseHead failure(IRestCode restCode) {
        return ResponseHead.failure(restCode.getCode(), restCode.getMessage());
    }

    public static ResponseHead failure(String code, String message) {
        return ResponseHead.builder().build().setCode(code).setMessage(message).setTimestamp(Instant.now().toEpochMilli()).setSuccess(false).setError(true);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isError() {
        return this.error;
    }

    ResponseHead(String requestId, String code, String message, Long timestamp, Long taketime, String encoding, Boolean success, Boolean error) {
        this.requestId = requestId;
        this.code = code;
        this.message = message;
        this.timestamp = timestamp;
        this.taketime = taketime;
        this.encoding = encoding;
        this.success = success;
        this.error = error;
    }

    public static ResponseHeadBuilder builder() {
        return new ResponseHeadBuilder();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Long getTaketime() {
        return this.taketime;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Boolean getError() {
        return this.error;
    }

    public ResponseHead setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ResponseHead setCode(String code) {
        this.code = code;
        return this;
    }

    public ResponseHead setMessage(String message) {
        this.message = message;
        return this;
    }

    public ResponseHead setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ResponseHead setTaketime(Long taketime) {
        this.taketime = taketime;
        return this;
    }

    public ResponseHead setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public ResponseHead setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public ResponseHead setError(Boolean error) {
        this.error = error;
        return this;
    }

    public static class ResponseHeadBuilder {
        private String requestId;
        private String code;
        private String message;
        private Long timestamp;
        private Long taketime;
        private String encoding;
        private Boolean success;
        private Boolean error;

        ResponseHeadBuilder() {
        }

        public ResponseHeadBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public ResponseHeadBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ResponseHeadBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ResponseHeadBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ResponseHeadBuilder taketime(Long taketime) {
            this.taketime = taketime;
            return this;
        }

        public ResponseHeadBuilder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public ResponseHeadBuilder success(Boolean success) {
            this.success = success;
            return this;
        }

        public ResponseHeadBuilder error(Boolean error) {
            this.error = error;
            return this;
        }

        public ResponseHead build() {
            return new ResponseHead(this.requestId, this.code, this.message, this.timestamp, this.taketime, this.encoding, this.success, this.error);
        }

        public String toString() {
            return "ResponseHead.ResponseHeadBuilder(requestId=" + this.requestId + ", code=" + this.code + ", message=" + this.message + ", timestamp=" + this.timestamp + ", taketime=" + this.taketime + ", encoding=" + this.encoding + ", success=" + this.success + ", error=" + this.error + ")";
        }
    }
}

