/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.api.page;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pager
implements Serializable {
    private static final long serialVersionUID = 7123889202050120975L;
    private static final Logger logger = LoggerFactory.getLogger(Pager.class);
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_PAGE_INDEX = 1;
    protected int pageIndex;
    protected int pageSize;
    protected int pageCount = 0;
    protected int recordCount = 0;
    protected int sizeOfCurrentPage = 0;
    private int indexOfFirstItemOfCurrentPage = 0;
    private int prePageIndex = 0;
    private int nextPageIndex = 0;
    private boolean existsPrePage = false;
    private boolean existsNextPage = false;

    protected Pager() {
        this.pageIndex = 1;
        this.pageSize = 10;
    }

    public Pager(int pageIndex, int pageSize, int recordCount) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.recordCount = recordCount;
        this.calculate();
    }

    public static Pager of(int pageIndex, int pageSize, int recordCount) {
        return new Pager(pageIndex, pageSize, recordCount);
    }

    public boolean existsNextPage() {
        return this.existsNextPage;
    }

    public boolean existsPrePage() {
        return this.existsPrePage;
    }

    public int getIndexOfFirstItemOfCurrentPage() {
        return this.indexOfFirstItemOfCurrentPage;
    }

    public int getNextPageIndex() {
        return this.nextPageIndex;
    }

    public int getPrePageIndex() {
        return this.prePageIndex;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public int getSizeOfCurrentPage() {
        return this.sizeOfCurrentPage;
    }

    public void setSizeOfCurrentPage(int sizeOfCurrentPage) {
        this.sizeOfCurrentPage = sizeOfCurrentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    private void calculate() {
        logger.debug("\u8ba1\u7b97\u5206\u9875\u4fe1\u606f...");
        if (this.pageIndex <= 0) {
            if (logger.isDebugEnabled()) {
                logger.warn("pageIndex\u5c5e\u6027\u7684\u53d6\u503c\u4e3a" + this.pageIndex + ", \u73b0\u5c06\u5176\u53d6\u503c\u4fee\u6b63\u4e3a1");
            }
            this.pageIndex = 1;
        }
        if (this.recordCount < 0) {
            if (logger.isDebugEnabled()) {
                logger.warn("recordCount\u5c5e\u6027\u7684\u53d6\u503c\u4e3a" + this.recordCount + ", \u73b0\u5c06\u5176\u53d6\u503c\u4fee\u6b63\u4e3a0");
            }
            this.recordCount = 0;
        }
        if (this.pageSize <= 0) {
            if (logger.isDebugEnabled()) {
                logger.warn("pageSize\u5c5e\u6027\u7684\u53d6\u503c\u4e3a" + this.pageSize + ", \u73b0\u5c06\u5176\u53d6\u503c\u4fee\u6b63\u4e3a\u9ed8\u8ba4\u503c" + 10);
            }
            this.pageSize = 10;
        }
        this.pageCount = this.recordCount % this.pageSize == 0 ? this.recordCount / this.pageSize : this.recordCount / this.pageSize + 1;
        if (this.pageCount <= 0) {
            this.pageIndex = 0;
        } else if (this.pageCount < this.pageIndex) {
            this.pageIndex = this.pageCount;
        }
        if (this.pageIndex <= 1) {
            this.prePageIndex = 1;
            this.existsPrePage = false;
        } else {
            this.prePageIndex = this.pageIndex - 1;
            this.existsPrePage = true;
        }
        if (this.pageIndex <= 1) {
            if (this.pageIndex < 1) {
                this.nextPageIndex = 1;
                this.existsNextPage = false;
            } else if (this.pageCount >= 2) {
                this.nextPageIndex = 2;
                this.existsNextPage = true;
            } else {
                this.nextPageIndex = 1;
                this.existsNextPage = false;
            }
        } else if (this.pageIndex >= this.pageCount) {
            this.nextPageIndex = this.pageCount;
            this.existsNextPage = false;
        } else {
            this.nextPageIndex = this.pageIndex + 1;
            this.existsNextPage = true;
        }
        this.indexOfFirstItemOfCurrentPage = this.pageIndex <= 0 ? 0 : (this.pageIndex - 1) * this.pageSize;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5206\u9875\u4fe1\u606f\u8ba1\u7b97\u7ed3\u679c\u3010\u76ee\u6807\u9875\u9762\u9875\u7801\uff1a" + this.pageIndex + ",\u524d\u4e00\u9875\u9762\u9875\u7801\uff1a" + this.prePageIndex + ",\u4e0b\u4e00\u9875\u9762\u9875\u7801\uff1a" + this.nextPageIndex + ",\u603b\u9875\u6570\uff1a" + this.pageCount + ",\u603b\u8bb0\u5f55\u6570\uff1a" + this.recordCount + ",\u662f\u5426\u5b58\u5728\u524d\u4e00\u9875\uff1a" + this.existsPrePage + ",\u662f\u5426\u5b58\u5728\u4e0b\u4e00\u9875\uff1a" + this.existsNextPage + "\u3011");
        }
    }
}

