/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.api.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcgroup.framework.common.entity.IRestCode;
import com.pcgroup.framework.common.entity.RestCode;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Response<T> {
    private String resultCode;
    private String resultMessage;
    private T data;

    public static Response<Void> success() {
        return Response.success(RestCode.SUCCESS);
    }

    public static Response<Void> success(IRestCode restCode) {
        return Response.success(restCode, null);
    }

    public static <T> Response<T> success(T data) {
        return Response.success((IRestCode)RestCode.SUCCESS, data);
    }

    public static <T> Response<T> success(IRestCode restCode, T data) {
        return Response.success(restCode.getCode(), restCode.getMessage(), data);
    }

    public static Response<Void> success(String resultCode, String resultMessage) {
        return Response.success(resultCode, resultMessage, null);
    }

    public static <T> Response<T> success(String resultCode, String resultMessage, T data) {
        return Response.builder().build().setResultCode(resultCode).setResultMessage(resultMessage).setData(data);
    }

    public static Response<Void> successCode(String resultCode) {
        return Response.successCode(resultCode, null);
    }

    public static <T> Response<T> successCode(String resultCode, T data) {
        return Response.success(resultCode, RestCode.SUCCESS.getMessage(), data);
    }

    public static Response<Void> successMessage(String resultMessage) {
        return Response.successMessage(resultMessage, null);
    }

    public static <T> Response<T> successMessage(String resultMessage, T data) {
        return Response.success(RestCode.SUCCESS.getCode(), resultMessage, data);
    }

    public static Response<Void> error() {
        return Response.error(RestCode.FAILURE);
    }

    public static Response<Void> error(IRestCode restCode) {
        return Response.error(restCode.getCode(), restCode.getMessage());
    }

    public static <T> Response<T> error(T data) {
        return Response.error((IRestCode)RestCode.FAILURE, data);
    }

    public static <T> Response<T> error(IRestCode restCode, T data) {
        return Response.error(restCode.getCode(), restCode.getMessage(), data);
    }

    public static Response<Void> error(String resultCode, String resultMessage) {
        return Response.error(resultCode, resultMessage, null);
    }

    public static <T> Response<T> error(String resultCode, String resultMessage, T data) {
        return Response.builder().build().setResultCode(resultCode).setResultMessage(resultMessage).setData(data);
    }

    public static Response<Void> errorCode(String resultCode) {
        return Response.errorCode(resultCode, null);
    }

    public static <T> Response<T> errorCode(String resultCode, T data) {
        return Response.error(resultCode, RestCode.FAILURE.getMessage(), data);
    }

    public static Response<Void> errorMessage(String resultMessage) {
        return Response.errorMessage(resultMessage, null);
    }

    public static <T> Response<T> errorMessage(String resultMessage, T body) {
        return Response.error(RestCode.FAILURE.getCode(), resultMessage, body);
    }

    @JsonIgnore
    public boolean isSuccess() {
        return RestCode.SUCCESS.getCode().equals(this.getResultCode());
    }

    @JsonIgnore
    public boolean isError() {
        return !this.isSuccess();
    }

    public static <T> ResponseBuilder<T> builder() {
        return new ResponseBuilder();
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public T getData() {
        return this.data;
    }

    public Response<T> setResultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public Response<T> setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
        return this;
    }

    public Response<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resultCode = this.getResultCode();
        String other$resultCode = other.getResultCode();
        if (this$resultCode == null ? other$resultCode != null : !this$resultCode.equals(other$resultCode)) {
            return false;
        }
        String this$resultMessage = this.getResultMessage();
        String other$resultMessage = other.getResultMessage();
        if (this$resultMessage == null ? other$resultMessage != null : !this$resultMessage.equals(other$resultMessage)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resultCode = this.getResultCode();
        result = result * 59 + ($resultCode == null ? 43 : $resultCode.hashCode());
        String $resultMessage = this.getResultMessage();
        result = result * 59 + ($resultMessage == null ? 43 : $resultMessage.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(resultCode=" + this.getResultCode() + ", resultMessage=" + this.getResultMessage() + ", data=" + this.getData() + ")";
    }

    public Response() {
    }

    public Response(String resultCode, String resultMessage, T data) {
        this.resultCode = resultCode;
        this.resultMessage = resultMessage;
        this.data = data;
    }

    public static class ResponseBuilder<T> {
        private String resultCode;
        private String resultMessage;
        private T data;

        ResponseBuilder() {
        }

        public ResponseBuilder<T> resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public ResponseBuilder<T> resultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
            return this;
        }

        public ResponseBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Response<T> build() {
            return new Response<T>(this.resultCode, this.resultMessage, this.data);
        }

        public String toString() {
            return "Response.ResponseBuilder(resultCode=" + this.resultCode + ", resultMessage=" + this.resultMessage + ", data=" + this.data + ")";
        }
    }
}

