/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.mongodb.impl;

import com.pcgroup.framework.api.page.IPage;
import com.pcgroup.framework.api.page.PageQueryResultDefaultImpl;
import com.pcgroup.framework.api.page.Pager;
import com.pcgroup.framework.mongodb.base.IMongoDBBase;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class MongoDBBaseImpl<T>
implements IMongoDBBase<T> {
    @Autowired
    protected MongoTemplate mgt;

    public Class<T> getEntityClass() {
        Class tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return tClass;
    }

    @Override
    public void save(T entity) {
        this.mgt.save(entity);
    }

    @Override
    public void update(T entity) {
        Map<String, Object> map = null;
        try {
            map = this.parseEntity(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String idName = null;
        Object idValue = null;
        Update update = new Update();
        if (MapUtils.isNotEmpty(map)) {
            for (String key : map.keySet()) {
                if (key.indexOf("{") != -1) {
                    idName = key.substring(key.indexOf("{") + 1, key.indexOf("}"));
                    idValue = map.get(key);
                    continue;
                }
                update.set(key, map.get(key));
            }
        }
        this.mgt.updateFirst(new Query().addCriteria((CriteriaDefinition)Criteria.where(idName).is(idValue)), (UpdateDefinition)update, this.getEntityClass());
    }

    @Override
    public void delete(Serializable ... ids) {
        if (ArrayUtils.isNotEmpty((Object[])ids)) {
            for (Serializable id : ids) {
                this.mgt.remove(this.mgt.findById((Object)id, this.getEntityClass()));
            }
        }
    }

    @Override
    public T find(Serializable id) {
        return (T)this.mgt.findById((Object)id, this.getEntityClass());
    }

    @Override
    public List<T> findAll() {
        return this.mgt.findAll(this.getEntityClass());
    }

    @Override
    public List<T> findAll(String order) {
        List<Sort.Order> orderList = this.parseOrder(order);
        if (CollectionUtils.isEmpty(orderList)) {
            return this.findAll();
        }
        return this.mgt.find(new Query().with(Sort.by(orderList)), this.getEntityClass());
    }

    @Override
    public List<T> findByProp(String propName, Object propValue) {
        return this.findByProp(propName, propValue, null);
    }

    @Override
    public List<T> findByProp(String propName, Object propValue, String order) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)propName).is(propValue));
        List<Sort.Order> orderList = this.parseOrder(order);
        if (CollectionUtils.isNotEmpty(orderList)) {
            query.with(Sort.by(orderList));
        }
        return this.mgt.find(query, this.getEntityClass());
    }

    @Override
    public List<T> findByProps(String[] propName, Object[] propValue) {
        return this.findByProps(propName, propValue, null);
    }

    @Override
    public List<T> findByProps(String[] propName, Object[] propValue, String order) {
        Query query = this.createQuery(propName, propValue, order);
        return this.mgt.find(query, this.getEntityClass());
    }

    @Override
    public T uniqueByProp(String propName, Object propValue) {
        return (T)this.mgt.findOne(new Query((CriteriaDefinition)Criteria.where((String)propName).is(propValue)), this.getEntityClass());
    }

    @Override
    public T uniqueByProps(String[] propName, Object[] propValue) {
        Query query = this.createQuery(propName, propValue, null);
        return (T)this.mgt.findOne(query, this.getEntityClass());
    }

    @Override
    public int countByCondition(String[] params, Object[] values) {
        Query query = this.createQuery(params, values, null);
        Long count = this.mgt.count(query, this.getEntityClass());
        return count.intValue();
    }

    @Override
    public IPage<T> pageAll(int pageNo, int pageSize) {
        return this.pageAll(pageNo, pageSize, null);
    }

    @Override
    public IPage<T> pageAll(int pageNo, int pageSize, String order) {
        return this.pageByProp(pageNo, pageSize, null, null, order);
    }

    @Override
    public IPage<T> pageByProp(int pageNo, int pageSize, String param, Object value) {
        return this.pageByProp(pageNo, pageSize, param, value, null);
    }

    @Override
    public IPage<T> pageByProp(int pageNo, int pageSize, String param, Object value, String order) {
        String[] params = null;
        Object[] values = null;
        if (StringUtils.isNotEmpty((CharSequence)param)) {
            params = new String[]{param};
            values = new Object[]{value};
        }
        return this.pageByProps(pageNo, pageSize, params, values, order);
    }

    @Override
    public IPage<T> pageByProps(int pageNo, int pageSize, String[] params, Object[] values) {
        return this.pageByProps(pageNo, pageSize, params, values, null);
    }

    @Override
    public IPage<T> pageByProps(int pageNo, int pageSize, String[] params, Object[] values, String order) {
        PageQueryResultDefaultImpl page = new PageQueryResultDefaultImpl();
        int count = this.countByCondition(params, values);
        Pager pager = Pager.of((int)pageNo, (int)pageSize, (int)count);
        Query query = this.createQuery(params, values, order);
        query.skip((long)pageNo);
        query.limit(pageSize);
        page.setData(this.mgt.find(query, this.getEntityClass()));
        page.setPager(pager);
        return page;
    }

    protected Query createQuery(String[] params, Object[] values, String order) {
        List<Sort.Order> orderList;
        Query query = new Query();
        if (ArrayUtils.isNotEmpty((Object[])params) && ArrayUtils.isNotEmpty((Object[])values)) {
            for (int i = 0; i < params.length; ++i) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)params[i]).is(values[i]));
            }
        }
        if (CollectionUtils.isNotEmpty(orderList = this.parseOrder(order))) {
            query.with(Sort.by(orderList));
        }
        return query;
    }

    protected List<Sort.Order> parseOrder(String order) {
        ArrayList<Sort.Order> list = null;
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            list = new ArrayList<Sort.Order>();
            String[] fields = order.split(",");
            Sort.Order o = null;
            String[] item = null;
            for (int i = 0; i < fields.length; ++i) {
                if (StringUtils.isEmpty((CharSequence)fields[i])) continue;
                item = fields[i].split(" ");
                if (item.length == 1) {
                    o = new Sort.Order(Sort.Direction.ASC, item[0]);
                } else if (item.length == 2) {
                    o = new Sort.Order("desc".equalsIgnoreCase(item[1]) ? Sort.Direction.DESC : Sort.Direction.ASC, item[0]);
                } else {
                    throw new RuntimeException("\u6392\u5e8f\u5b57\u6bb5\u53c2\u6570\u89e3\u6790\u51fa\u9519");
                }
                list.add(o);
            }
        }
        return list;
    }

    protected Map<String, Object> parseEntity(T t) throws Exception {
        Object[] methods;
        Field[] declaredFields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String idName = "";
        for (Field field : declaredFields = this.getEntityClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            field.setAccessible(true);
            map.put("{" + field.getName() + "}", field.get(t));
            idName = field.getName();
            break;
        }
        if (ArrayUtils.isNotEmpty((Object[])(methods = this.getEntityClass().getDeclaredMethods()))) {
            for (Object method : methods) {
                String fieldName;
                if (!((Method)method).getName().startsWith("get") || ((Method)method).getModifiers() != 1 || (fieldName = this.parse2FieldName(((Method)method).getName())).equals(idName)) continue;
                map.put(fieldName, ((Method)method).invoke(t, new Object[0]));
            }
        }
        return map;
    }

    private String parse2FieldName(String methodName) {
        String name = methodName.replace("get", "");
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }
}

