/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.test.controller;

import com.pcgroup.framework.api.entity.Response;
import com.pcgroup.framework.core.id.IdGenerator;
import com.pcgroup.framework.redis.Redis;
import com.pcgroup.framework.test.domain.data.Brand;
import com.pcgroup.framework.test.domain.data.TestId;
import com.pcgroup.framework.test.service.TestIdService;
import com.pcgroup.framework.test.service.TestService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private final TestService testService;
    private final Redis redis;
    private final TestIdService testIdService;
    private final IdGenerator idGenerator;

    @GetMapping(value={"/get"})
    public Response<Brand> testGet() {
        this.redis.set("hello", "world");
        return Response.success((Object)this.testService.selectByPrimaryKey((Object)11111111));
    }

    @GetMapping(value={"/brand/{brandId}"})
    public Response<Brand> testGet(@PathVariable Integer brandId) {
        return Response.success((Object)this.testService.selectByPrimaryKey((Object)brandId));
    }

    @PostMapping(value={"/post"})
    public Response<Brand> testPost() {
        this.redis.set("Sophie", "Marceau");
        return Response.success((Object)this.testService.selectByPrimaryKey((Object)100000001));
    }

    @GetMapping(value={"/uid"})
    public Response<Void> testUid() {
        System.out.println(this.idGenerator.getLongId());
        this.testIdService.insert((Object)new TestId());
        return Response.success();
    }

    public TestController(TestService testService, Redis redis, TestIdService testIdService, IdGenerator idGenerator) {
        this.testService = testService;
        this.redis = redis;
        this.testIdService = testIdService;
        this.idGenerator = idGenerator;
    }
}

