/*
 * Decompiled with CFR 0.152.
 */
package com.pcgroup.framework.test.controller;

import com.pcgroup.framework.api.entity.Response;
import com.pcgroup.framework.core.id.IdGenerator;
import com.pcgroup.framework.redis.Redis;
import com.pcgroup.framework.test.config.properties.TestProperties;
import com.pcgroup.framework.test.domain.data.Brand;
import com.pcgroup.framework.test.domain.data.TestId;
import com.pcgroup.framework.test.service.TestIdService;
import com.pcgroup.framework.test.service.TestService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger logger = LoggerFactory.getLogger(TestController.class);
    private final TestService testService;
    private final Redis redis;
    private final TestIdService testIdService;
    private final IdGenerator idGenerator;
    private final TestProperties testProperties;
    @Value(value="${server.port}")
    private int port;

    @GetMapping(value={"/get"})
    public Response<Brand> testGet() {
        this.redis.set("hello", "world");
        return Response.success((Object)this.testService.selectByPrimaryKey((Object)11111111));
    }

    @GetMapping(value={"/brand/{brandId}"})
    public Response<Brand> testGet(@PathVariable Integer brandId) {
        return Response.success((Object)this.testService.selectByPrimaryKey((Object)brandId));
    }

    @PostMapping(value={"/post"})
    public Response<Brand> testPost() {
        this.redis.set("Sophie", "Marceau");
        return Response.success((Object)this.testService.selectByPrimaryKey((Object)100000001));
    }

    @GetMapping(value={"/uid"})
    public Response<Void> testUid() {
        logger.info("IdGenerator: {}", (Object)this.idGenerator.getLongId());
        this.testIdService.insert((Object)new TestId());
        return Response.success();
    }

    @GetMapping(value={"/config"})
    public Response<Void> testConfig() throws UnknownHostException {
        Map nodeMap = this.testProperties.getNodeMap();
        logger.info("Node map: {}", (Object)nodeMap);
        InetAddress address = InetAddress.getLocalHost();
        String hostAddress = address.getHostAddress();
        String key = hostAddress + "-" + this.port;
        logger.info("Node map key: {}", (Object)key);
        boolean flag = nodeMap.containsKey(key);
        logger.info("Flag: {}", (Object)flag);
        if (flag) {
            String value = (String)nodeMap.get(key);
            logger.info("Node map value: {}", (Object)value);
            String[] split = value.split("[|]");
            logger.info("Param[0]: {}", (Object)split[0]);
            logger.info("Param[1]: {}", (Object)split[1]);
        }
        return Response.success();
    }

    public TestController(TestService testService, Redis redis, TestIdService testIdService, IdGenerator idGenerator, TestProperties testProperties) {
        this.testService = testService;
        this.redis = redis;
        this.testIdService = testIdService;
        this.idGenerator = idGenerator;
        this.testProperties = testProperties;
    }
}

